/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.core.analysis.PeriodicMaintenanceJob;
import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.index.testimpact.PrioritizedTestListIndex;
import com.teamscale.index.testimpact.TestMinimizationJobOptionsIndex;
import com.teamscale.index.testimpact.TestMinimizationJobRun;
import com.teamscale.index.testimpact.TestMinimizationJobsIndex;
import com.teamscale.index.utils.AsyncServiceJobRun;
import java.time.Duration;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.date.DurationUtils;

@PeriodicMaintenanceJob(cronExpression="0 */4 * * *")
public class TestMinimizationCleanupTrigger
extends MaintenanceTriggerBase {
    private static final Duration CLEANUP_RESULTS_AFTER = Duration.ofDays(30L);
    private static final Duration DISCARD_UNFINISHED_JOBS_AFTER = Duration.ofDays(2L);

    public void execute() throws Exception {
        ProjectIndex projectIndex = (ProjectIndex)this.indexLayer.openGlobalIndex(ProjectIndex.class);
        for (ProjectInfo projectInfo : projectIndex.getAllProjectInfos()) {
            CommitResolvingStorageSystem storageSystem = this.indexLayer.openProjectStorageSystem(projectInfo);
            TestMinimizationJobsIndex jobsIndex = (TestMinimizationJobsIndex)storageSystem.openProjectIndex(TestMinimizationJobsIndex.class, null);
            for (Pair entry : jobsIndex.getAllJobs()) {
                boolean clearJobResults;
                TestMinimizationJobRun job = (TestMinimizationJobRun)entry.getSecond();
                boolean removeJob = job.getStatus() != AsyncServiceJobRun.EJobStatus.DONE && DurationUtils.elapsed((Duration)DISCARD_UNFINISHED_JOBS_AFTER, (long)job.getStartTimestamp());
                boolean bl = clearJobResults = removeJob || job.getStatus() == AsyncServiceJobRun.EJobStatus.DONE && DurationUtils.elapsed((Duration)CLEANUP_RESULTS_AFTER, (long)job.getStartTimestamp());
                if (removeJob) {
                    TestMinimizationJobOptionsIndex optionsIndex = (TestMinimizationJobOptionsIndex)storageSystem.openProjectIndex(TestMinimizationJobOptionsIndex.class, null);
                    optionsIndex.removeJobOptions(job.getId());
                    jobsIndex.removeJob(job.getId());
                }
                if (!clearJobResults) continue;
                PrioritizedTestListIndex resultsIndex = (PrioritizedTestListIndex)storageSystem.openProjectIndex(PrioritizedTestListIndex.class, null);
                resultsIndex.clearRankingResult(job.getId());
            }
        }
    }
}

