/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.user.User;
import com.teamscale.index.testimpact.TestMinimizationRequestOptions;
import com.teamscale.index.testimpact.TiaRequestOptions;
import com.teamscale.service.testimpact.ITestMinimizationServiceApi;
import com.teamscale.service.testimpact.ImpactedTestUtils;
import com.teamscale.service.testimpact.MinimizationProgressCallback;
import com.teamscale.service.testimpact.PrioritizableTestsRetriever;
import com.teamscale.service.testimpact.TestDataRetriever;
import com.teamscale.service.testimpact.TestMinimizationResult;
import com.teamscale.service.testimpact.TestPrioritizationData;
import com.teamscale.service.testimpact.TestReductionApiBase;
import com.teamscale.service.testimpact.TiaDataRetrieverOptions;
import com.teamscale.service.testimpact.prioritization.ITestPrioritizationStrategy;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import com.teamscale.service.testimpact.prioritization.PrioritizableTestCluster;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;

@Path(value="api/projects/{project}/minimized-tests")
public class TestMinimizationService
extends TestReductionApiBase
implements ITestMinimizationServiceApi {
    @Override
    public TestMinimizationResult getMinimizedTests(TestMinimizationRequestOptions testMinimizationRequestOptions) throws StorageException, InterruptedException {
        return TestMinimizationService.minimizeTestSuite(testMinimizationRequestOptions, MinimizationProgressCallback.dummy(), this.serviceInfo.getInternalId(), this.serviceInfo.getUser(), this.serviceInfo.getGlobalStorageSystem(), this.serviceInfo.getProjectStorageSystem(), this.serviceInfo.getIndexLayer());
    }

    public static TestMinimizationResult minimizeTestSuite(TestMinimizationRequestOptions testMinimizationRequestOptions, MinimizationProgressCallback callback, InternalProjectId projectId, User user, GlobalStorageSystem globalStorageSystem, CommitResolvingStorageSystem projectStorageSystem, IndexLayer indexLayer) throws StorageException, InterruptedException {
        ITestPrioritizationStrategy prioritizationStrategy;
        TestPrioritizationData queriedTestsToMinimize;
        PrioritizableTestsRetriever prioritizableTestsRetriever;
        TiaDataRetrieverOptions tiaDataRetrieverOptions;
        TiaRequestOptions tiaRequestOptions = testMinimizationRequestOptions.toTiaRequestOptions();
        try (MinimizationProgressCallback ignored = callback.processStarts("Initializing");){
            tiaDataRetrieverOptions = TiaDataRetrieverOptions.create(tiaRequestOptions, projectId, user, indexLayer);
            prioritizableTestsRetriever = new PrioritizableTestsRetriever(tiaDataRetrieverOptions, globalStorageSystem, projectStorageSystem, user);
        }
        callback.reportProgress();
        try (MinimizationProgressCallback ignored = callback.processStarts("Loading Coverage Data");){
            ImpactedTestUtils.ensureCommitIsProcessed(projectStorageSystem, tiaDataRetrieverOptions);
            queriedTestsToMinimize = TestMinimizationService.getTestPrioritizationData(testMinimizationRequestOptions, tiaDataRetrieverOptions, prioritizableTestsRetriever);
        }
        callback.reportProgress();
        ignored = callback.processStarts("Initializing Test Minimization Strategy");
        try {
            TestDataRetriever dataRetriever = new TestDataRetriever(projectStorageSystem, tiaDataRetrieverOptions.getEndCommit(), tiaDataRetrieverOptions.tiaRequestOptions().getCoveringPath());
            prioritizationStrategy = TestMinimizationService.initTestPrioritizationStrategy(dataRetriever, queriedTestsToMinimize, callback, tiaRequestOptions.getPrioritizationStrategy());
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        callback.reportProgress();
        List<PrioritizableTestCluster> prioritizationTestClusters = TestMinimizationService.getTestClustersMatchingPattern(testMinimizationRequestOptions, queriedTestsToMinimize, prioritizationStrategy, callback);
        double testCoveragePercentage = TestMinimizationService.getTestCoveragePercentage(queriedTestsToMinimize, prioritizationTestClusters);
        callback.reportProgress();
        return new TestMinimizationResult(prioritizationTestClusters, testCoveragePercentage);
    }

    private static TestPrioritizationData getTestPrioritizationData(TestMinimizationRequestOptions testMinimizationRequestOptions, TiaDataRetrieverOptions tiaDataRetrieverOptions, PrioritizableTestsRetriever dataRetriever) throws StorageException {
        try {
            if (CollectionUtils.isNullOrEmpty((Collection)testMinimizationRequestOptions.getTests())) {
                return dataRetriever.getTestPrioritizationDataForMinimization(testMinimizationRequestOptions.getQuery(), tiaDataRetrieverOptions.getPartitions());
            }
            return dataRetriever.getTestPrioritizationDataForMinimization(testMinimizationRequestOptions.getTests());
        }
        catch (QueryCompilationException | QueryParsingException e) {
            throw new BadRequestException(e);
        }
    }

    private static double getTestCoveragePercentage(TestPrioritizationData testPrioritizationData, List<PrioritizableTestCluster> selectedClusters) {
        Set coveredMethods = selectedClusters.stream().flatMap(test -> test.getCoveredMethods().stream()).collect(Collectors.toSet());
        int numberOfUncoveredMethods = (int)testPrioritizationData.getMethodsToTest().stream().filter(method -> !coveredMethods.contains(method)).count();
        return TestMinimizationService.getCoveragePercentage(testPrioritizationData.getMethodsToTest().size(), numberOfUncoveredMethods);
    }

    private static List<PrioritizableTestCluster> getTestClustersMatchingPattern(TestMinimizationRequestOptions testMinimizationRequestOptions, TestPrioritizationData allTests, ITestPrioritizationStrategy prioritizationStrategy, MinimizationProgressCallback callback) throws InterruptedException, StorageException {
        SetMap<String, PrioritizableTest> testByClusterId = TestMinimizationService.clusterTests(allTests.getSelectedTests(), testMinimizationRequestOptions.getClusteringRegex());
        callback.reportProgress();
        List<PrioritizableTestCluster> testClusters = TestMinimizationService.getTestClusters(testByClusterId, allTests, prioritizationStrategy, callback, testMinimizationRequestOptions.getMaxTestSuiteRuntime());
        callback.reportProgress();
        return testClusters;
    }

    private static SetMap<String, PrioritizableTest> clusterTests(Set<PrioritizableTest> tests, Pattern clusteringRegex) {
        SetMap testByClusterId = new SetMap();
        tests.forEach(selectedTest -> {
            Matcher matcher = clusteringRegex.matcher(selectedTest.getUniformPathString());
            if (!matcher.find()) {
                throw new BadRequestException("The given clustering-regex did not match the test " + selectedTest.getUniformPathString() + "!");
            }
            if (matcher.groupCount() < 1) {
                throw new BadRequestException("The given clustering-regex does not contain a valid capture group!");
            }
            String clusterId = matcher.group(1);
            testByClusterId.add((Object)clusterId, selectedTest);
        });
        return testByClusterId;
    }

    private static double getCoveragePercentage(int allMethods, int uncoveredMethods) {
        return 100.0 - 100.0 * (double)uncoveredMethods / (double)allMethods;
    }
}

