/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.prioritization.strategies;

import com.teamscale.index.testimpact.MethodId;
import com.teamscale.service.testimpact.MinimizationProgressCallback;
import com.teamscale.service.testimpact.prioritization.IPrioritizableTests;
import com.teamscale.service.testimpact.prioritization.PrioritizeUnderBudgetCallback;
import com.teamscale.service.testimpact.prioritization.strategies.ERoundState;
import com.teamscale.service.testimpact.prioritization.strategies.TestPrioritizationStrategyBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;

public abstract class RoundBasedTestPrioritizationStrategyBase
extends TestPrioritizationStrategyBase {
    public RoundBasedTestPrioritizationStrategyBase(MinimizationProgressCallback progressCallback) {
        super(progressCallback);
    }

    @Override
    public <T extends IPrioritizableTests> List<T> orderMultipleTests(Collection<T> relevantTests, Set<MethodId> methodsToTest, @Nullable Long maxTestSuiteRuntimeMs, PrioritizeUnderBudgetCallback<T> budgetCallback) throws InterruptedException, StorageException {
        ArrayList result = new ArrayList();
        LinkedHashSet<IPrioritizableTests> remainingTests = new LinkedHashSet<IPrioritizableTests>(relevantTests.stream().sorted(Comparator.comparing(IPrioritizableTests::getIdentifier)).toList());
        Long remainingBudget = maxTestSuiteRuntimeMs;
        ERoundState roundState = ERoundState.startState();
        try (MinimizationProgressCallback ignore = this.progressCallback.processStarts("Prioritizing Tests");){
            int initialNumberOfTests = remainingTests.size();
            this.progressCallback.setProcessMaxSteps(initialNumberOfTests);
            while (!roundState.isEndState() || !remainingTests.isEmpty()) {
                Pair<List<IPrioritizableTests>, Long> prioritizedTestsOfThisRound = this.performPrioritizationRound(remainingTests, roundState, result.size(), remainingBudget, budgetCallback);
                List testsInCurrentPrioritizationRound = (List)prioritizedTestsOfThisRound.getFirst();
                remainingBudget = (Long)prioritizedTestsOfThisRound.getSecond();
                result.addAll(testsInCurrentPrioritizationRound);
                testsInCurrentPrioritizationRound.forEach(remainingTests::remove);
                if (remainingBudget != null && remainingBudget == 0L || RoundBasedTestPrioritizationStrategyBase.shouldAbortTestPrioritization(roundState, testsInCurrentPrioritizationRound)) break;
                roundState = roundState.nextState();
            }
            ArrayList arrayList = result;
            return arrayList;
        }
    }

    private static <T extends IPrioritizableTests> boolean shouldAbortTestPrioritization(ERoundState roundState, List<T> prioritizedTestsOfThisRound) {
        return prioritizedTestsOfThisRound.isEmpty() && roundState.isEndState();
    }

    private <T extends IPrioritizableTests> Pair<List<T>, Long> performPrioritizationRound(Set<T> availableTests, ERoundState roundState, int rankOffset, @Nullable Long remainingBudget, PrioritizeUnderBudgetCallback<T> budgetCallback) throws InterruptedException, StorageException {
        ArrayList<T> result = new ArrayList<T>();
        availableTests = this.filterAvailableTests(availableTests, roundState);
        this.updateTestInfosBeforePrioritizationRound(availableTests, roundState);
        while (!(availableTests.isEmpty() || remainingBudget != null && remainingBudget <= 0L || this.shouldAbortPrioritizationRound(availableTests, roundState))) {
            T selectedTest = RoundBasedTestPrioritizationStrategyBase.selectNextTestInPrioritizationRound(availableTests);
            selectedTest = budgetCallback.prioritizeTests(selectedTest, remainingBudget);
            if (remainingBudget != null) {
                long selectedTestDuration = selectedTest.getDurationInMs(10000L);
                if (remainingBudget < selectedTestDuration) {
                    availableTests.remove(selectedTest);
                    continue;
                }
                remainingBudget = remainingBudget - selectedTestDuration;
            }
            result.add(selectedTest);
            selectedTest.setRank(rankOffset + result.size());
            availableTests.remove(selectedTest);
            this.updateTestInfosAfterTestSelection(availableTests, selectedTest, roundState);
            this.progressCallback.reportProgress();
        }
        return new Pair(result, (Object)remainingBudget);
    }

    protected <T extends IPrioritizableTests> Set<T> filterAvailableTests(Set<T> availableTests, ERoundState roundState) {
        return availableTests;
    }

    private static <T extends IPrioritizableTests> T selectNextTestInPrioritizationRound(Set<T> availableTests) {
        return RoundBasedTestPrioritizationStrategyBase.getTestWithHighestScore(availableTests);
    }

    protected <T extends IPrioritizableTests> void updateTestInfosAfterTestSelection(Set<T> availableTests, T selectedTest, ERoundState roundState) {
        this.updateTestScores(availableTests);
    }

    private <T extends IPrioritizableTests> void updateTestScores(Set<T> availableTests) {
        for (IPrioritizableTests test : availableTests) {
            test.setCurrentScore(this.computeCurrentTestScore(test));
        }
    }

    private static <T extends IPrioritizableTests> T getTestWithHighestScore(Set<T> availableTests) {
        IPrioritizableTests best = null;
        for (IPrioritizableTests availableTest : availableTests) {
            if (best != null && IPrioritizableTests.COMPARATOR_BY_SCORE.compare(availableTest, best) <= 0) continue;
            best = availableTest;
        }
        return (T)best;
    }

    protected <T extends IPrioritizableTests> void updateTestInfosBeforePrioritizationRound(Set<T> availableTests, ERoundState roundState) {
        this.updateTestScores(availableTests);
    }

    protected abstract <T extends IPrioritizableTests> double computeCurrentTestScore(T var1);

    protected abstract <T extends IPrioritizableTests> boolean shouldAbortPrioritizationRound(Set<T> var1, ERoundState var2);
}

