/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.user;

import com.teamscale.core.option.IOption;
import com.teamscale.core.option.OptionDescriptor;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.OptionRegistryBase;
import com.teamscale.core.option.user.UserOptionIndex;
import com.teamscale.core.option.user.UserOptionRegistry;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.authorization.RequiresUserPermission;
import com.teamscale.service.option.OptionServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/users")
public class UserOptionService
extends OptionServiceBase {
    @GET
    @Operation(summary="Get schema", description="Retrieves the user option schema.", tags={"Users", "Administration"})
    @RequiresNoPermission
    @Path(value="options/schema")
    public List<OptionDescriptor> getUserOptionSchema() {
        return UserOptionRegistry.getInstance().getOptionDescriptors();
    }

    @GET
    @Path(value="{user}/options")
    @Operation(summary="Get options", description="Retrieves all available user options.", tags={"Users", "Administration"})
    @RequiresUserPermission(value={EBasicPermission.EDIT})
    public Map<String, IOption> getUserOptions(@Parameter(description="Name of the user to retrieve options for") @PathParam(value="user") String userName) throws StorageException {
        UserOptionIndex userOptionIndex = this.openGlobalIndex(UserOptionIndex.class);
        return UserOptionRegistry.getInstance().getOptions(userName, (OptionIndexBase)userOptionIndex);
    }

    @PUT
    @Path(value="{user}/options/{optionId}")
    @Operation(summary="Edit option", description="Edits the user option identified by the given name", tags={"Users", "Administration"}, responses={@ApiResponse(responseCode="404", description="No descriptor for option found."), @ApiResponse(responseCode="400", description="Could not parse the given option.")})
    @RequiresUserPermission(value={EBasicPermission.EDIT})
    public void editUserOption(@Parameter(description="Name of the user to edit the option for") @PathParam(value="user") String userName, @Parameter(description="Name of the option to edit") @PathParam(value="optionId") String optionId, @RequestBody(required=true, content={@Content(schema=@Schema(type="object"))}) byte[] optionJson) throws StorageException {
        UserOptionIndex userOptionIndex = this.openGlobalIndex(UserOptionIndex.class);
        this.editOption((OptionRegistryBase)UserOptionRegistry.getInstance(), optionJson, userName, optionId, false, (OptionIndexBase)userOptionIndex);
    }

    @DELETE
    @Path(value="{user}/options/{optionId}")
    @Operation(summary="Delete option", description="Deletes the user option identified by the given name", tags={"Users", "Administration"})
    @RequiresUserPermission(value={EBasicPermission.EDIT})
    public void deleteUserOption(@PathParam(value="user") String userName, @PathParam(value="optionId") String optionId) throws StorageException {
        UserOptionIndex userOptionIndex = this.openGlobalIndex(UserOptionIndex.class);
        this.deleteOption((OptionRegistryBase)UserOptionRegistry.getInstance(), userName, optionId, (OptionIndexBase)userOptionIndex);
    }
}

