/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.client;

import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.TeeClientHandler;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceLocationCollection;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.config.ConnectionAdvisor;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.HttpClient;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.util.Check;
import java.net.URI;
import java.util.Map;
import java.util.UUID;

public class VstsInfoClientHandler
extends TeeClientHandler
implements VssRestClientHandler {
    private static final UUID UUID_EMPTY = UUID.fromString("00000000-0000-0000-0000-000000000000");

    public VstsInfoClientHandler(String serverURL, Credentials credentials, ConnectionAdvisor advisor) {
        super(VstsInfoClientHandler.getFakeCollection(serverURL, credentials, advisor).getHTTPClient());
    }

    public VstsInfoClientHandler(HttpClient httpClient) {
        super(httpClient);
    }

    public <TEntity> VssRestRequest createRequest(HttpMethod method, URI target, TEntity value, String contentMediaType, Map<String, String> queryParameters, String acceptMediaType) {
        TeeClientHandler.TeeRestRequest request = (TeeClientHandler.TeeRestRequest)this.createRequest(method, target, UUID_EMPTY, null, value, contentMediaType, queryParameters, acceptMediaType);
        request.setFollowRedirects(false);
        return request;
    }

    private static TFSTeamProjectCollection getFakeCollection(String serverURL, Credentials credentials, ConnectionAdvisor advisor) {
        URI serverUri = URIUtils.newURI(serverURL);
        TFSTeamProjectCollection collection = new TFSTeamProjectCollection(serverUri, credentials, advisor);
        return collection;
    }

    @Override
    @Deprecated
    public ApiResourceLocationCollection loadLocations() {
        Check.isTrue(false, "The loadLocations method is not applicable for this client.");
        return null;
    }

    @Override
    @Deprecated
    protected ApiResourceVersion negotiateRequestVersion(UUID locationId, ApiResourceVersion version) {
        return null;
    }

    @Override
    @Deprecated
    public boolean checkConnection() {
        Check.isTrue(false, "The checkConnection method is not applicable for this client.");
        return false;
    }

    @Override
    @Deprecated
    public <TEntity> VssRestRequest createRequest(HttpMethod method, UUID locationId, Map<String, Object> routeValues, ApiResourceVersion version, TEntity value, String contentMediaType, Map<String, String> queryParameters, String acceptMediaType) {
        Check.isTrue(false, "This createRequest method is not applicable for this client.");
        return null;
    }
}

