/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.featureavailability.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.visualstudio.services.featureavailability.FeatureFlag;
import com.microsoft.alm.visualstudio.services.featureavailability.FeatureFlagPatch;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class FeatureAvailabilityHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected FeatureAvailabilityHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public ArrayList<FeatureFlag> getAllFeatureFlags() {
        UUID locationId = UUID.fromString("3e2b80f8-9e6f-441e-8393-005610692d9c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<FeatureFlag>>(){});
    }

    public ArrayList<FeatureFlag> getAllFeatureFlags(String userEmail) {
        UUID locationId = UUID.fromString("3e2b80f8-9e6f-441e-8393-005610692d9c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("userEmail", userEmail);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<FeatureFlag>>(){});
    }

    public FeatureFlag getFeatureFlagByName(String name) {
        UUID locationId = UUID.fromString("3e2b80f8-9e6f-441e-8393-005610692d9c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("name", name);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, FeatureFlag.class);
    }

    public FeatureFlag getFeatureFlagByNameAndUserEmail(String name, String userEmail) {
        UUID locationId = UUID.fromString("3e2b80f8-9e6f-441e-8393-005610692d9c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("name", name);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("userEmail", userEmail);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, FeatureFlag.class);
    }

    public FeatureFlag getFeatureFlagByNameAndUserId(String name, UUID userId) {
        UUID locationId = UUID.fromString("3e2b80f8-9e6f-441e-8393-005610692d9c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("name", name);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("userId", userId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, FeatureFlag.class);
    }

    public FeatureFlag updateFeatureFlag(FeatureFlagPatch state, String name, Boolean checkFeatureExists, Boolean setAtApplicationLevelAlso) {
        UUID locationId = UUID.fromString("3e2b80f8-9e6f-441e-8393-005610692d9c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("name", name);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("checkFeatureExists", checkFeatureExists);
        queryParameters.addIfNotNull("setAtApplicationLevelAlso", setAtApplicationLevelAlso);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, state, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, FeatureFlag.class);
    }

    public FeatureFlag updateFeatureFlag(FeatureFlagPatch state, String name, String userEmail, Boolean checkFeatureExists, Boolean setAtApplicationLevelAlso) {
        UUID locationId = UUID.fromString("3e2b80f8-9e6f-441e-8393-005610692d9c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("name", name);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("userEmail", userEmail);
        queryParameters.addIfNotNull("checkFeatureExists", checkFeatureExists);
        queryParameters.addIfNotNull("setAtApplicationLevelAlso", setAtApplicationLevelAlso);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, state, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, FeatureFlag.class);
    }
}

