/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.buildstatus;

import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.build.IQueuedBuild;
import com.microsoft.tfs.core.memento.Memento;
import com.microsoft.tfs.core.memento.XMLMemento;
import com.microsoft.tfs.core.persistence.LockMode;
import com.microsoft.tfs.core.persistence.PersistenceStore;
import com.microsoft.tfs.core.util.internal.MementoRepositorySerializer;
import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BuildStatusCache {
    private static final Log log = LogFactory.getLog(BuildStatusCache.class);
    private static final String CHILD_STORE_NAME = "TEE-BuildStatus";
    private static final String FILE_EXTENSION = ".xml";
    private static final String BUILD_STATUS_MEMENTO_NAME = "buildStatus";
    private static final String PROJECT_COLLECTION_PROPERTY_NAME = "projectCollection";
    private static final String BUILD_MEMENTO_NAME = "build";
    private static final String BUILD_ID_PROPERTY_NAME = "buildId";
    private final Memento memento;

    private BuildStatusCache(Memento buildStatusMemento) {
        Check.notNull(buildStatusMemento, "buildStatusMemento");
        this.memento = buildStatusMemento;
    }

    public static BuildStatusCache load(TFSTeamProjectCollection connection) {
        Check.notNull(connection, "connection");
        return BuildStatusCache.load(connection.getPersistenceStoreProvider().getCachePersistenceStore(), connection.getInstanceID().getGUIDString());
    }

    public static BuildStatusCache load(PersistenceStore baseStore, String projectCollectionId) {
        Memento buildStatusMemento;
        Check.notNull(baseStore, "baseStore");
        Check.notNull(projectCollectionId, "projectCollectionId");
        PersistenceStore currentStore = baseStore.getChildStore(CHILD_STORE_NAME);
        try {
            if (currentStore.containsItem(projectCollectionId + FILE_EXTENSION) && (buildStatusMemento = (Memento)currentStore.retrieveItem(projectCollectionId + FILE_EXTENSION, LockMode.WAIT_FOREVER, null, new MementoRepositorySerializer())) != null) {
                return new BuildStatusCache(buildStatusMemento);
            }
        }
        catch (Exception e) {
            log.warn((Object)"unable to load build status cache", (Throwable)e);
        }
        buildStatusMemento = new XMLMemento(BUILD_STATUS_MEMENTO_NAME);
        buildStatusMemento.putString(PROJECT_COLLECTION_PROPERTY_NAME, projectCollectionId);
        return new BuildStatusCache(buildStatusMemento);
    }

    public void save(TFSTeamProjectCollection collection) {
        Check.notNull(collection, "collection");
        this.save(collection.getPersistenceStoreProvider().getCachePersistenceStore(), collection.getInstanceID().getGUIDString());
    }

    public void save(PersistenceStore baseStore, String projectCollectionId) {
        Check.notNull(baseStore, "baseStore");
        Check.notNull(projectCollectionId, "projectCollectionId");
        try {
            baseStore.getChildStore(CHILD_STORE_NAME).storeItem(projectCollectionId + FILE_EXTENSION, this.memento, LockMode.WAIT_FOREVER, null, new MementoRepositorySerializer());
        }
        catch (Exception e) {
            log.warn((Object)"unable to save workspace cache", (Throwable)e);
        }
    }

    public void addBuild(IQueuedBuild build) {
        Check.notNull(build, BUILD_MEMENTO_NAME);
        this.addBuild(build.getID());
    }

    public void addBuild(int id) {
        Memento buildChild = this.memento.createChild(BUILD_MEMENTO_NAME);
        buildChild.putInteger(BUILD_ID_PROPERTY_NAME, id);
    }

    public void setBuilds(IQueuedBuild[] builds) {
        Check.notNull(builds, "builds");
        this.memento.removeChildren(BUILD_MEMENTO_NAME);
        for (int i = 0; i < builds.length; ++i) {
            this.addBuild(builds[i]);
        }
    }

    public void removeBuild(int id) {
        for (Memento buildChild : this.memento.getChildren(BUILD_MEMENTO_NAME)) {
            if (!buildChild.getInteger(BUILD_ID_PROPERTY_NAME).equals(id)) continue;
            this.memento.removeChild(buildChild);
            break;
        }
    }

    public List<Integer> getBuilds() {
        Memento[] buildChildren;
        ArrayList<Integer> buildIdList = new ArrayList<Integer>();
        for (Memento buildChild : buildChildren = this.memento.getChildren(BUILD_MEMENTO_NAME)) {
            buildIdList.add(buildChild.getInteger(BUILD_ID_PROPERTY_NAME));
        }
        return buildIdList;
    }
}

