/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.artifact.ArtifactID;
import com.microsoft.tfs.core.clients.build.IBuildController;
import com.microsoft.tfs.core.clients.build.IBuildDefinition;
import com.microsoft.tfs.core.clients.build.IBuildDefinitionSpec;
import com.microsoft.tfs.core.clients.build.IBuildDetail;
import com.microsoft.tfs.core.clients.build.IBuildRequest;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IProcessTemplate;
import com.microsoft.tfs.core.clients.build.IRetentionPolicy;
import com.microsoft.tfs.core.clients.build.ISchedule;
import com.microsoft.tfs.core.clients.build.IWorkspaceTemplate;
import com.microsoft.tfs.core.clients.build.exceptions.ConfigurationFolderPathNotFoundException;
import com.microsoft.tfs.core.clients.build.flags.BuildReason;
import com.microsoft.tfs.core.clients.build.flags.BuildStatus;
import com.microsoft.tfs.core.clients.build.flags.DefinitionQueueStatus;
import com.microsoft.tfs.core.clients.build.flags.DeleteOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.AttachedPropertyDictionary;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinition2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinitionSourceProvider;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildRequest;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.ProcessTemplate;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.RetentionPolicy;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.Schedule;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2010Helper;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.WorkspaceTemplate;
import com.microsoft.tfs.core.clients.build.internal.utils.BuildValidation;
import com.microsoft.tfs.core.clients.build.internal.utils.XamlHelper;
import com.microsoft.tfs.core.clients.build.soapextensions.ContinuousIntegrationType;
import com.microsoft.tfs.core.clients.build.soapextensions.DefinitionTriggerType;
import com.microsoft.tfs.core.clients.build.utils.BuildPath;
import com.microsoft.tfs.core.clients.linking.LinkingClient;
import com.microsoft.tfs.core.clients.versioncontrol.GetItemsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.core.exceptions.NotSupportedException;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.StringUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import ms.tfs.build.buildservice._04._BuildDefinition;
import ms.tfs.build.buildservice._04._BuildDefinitionSourceProvider;
import ms.tfs.build.buildservice._04._ProcessTemplate;
import ms.tfs.build.buildservice._04._PropertyValue;
import ms.tfs.build.buildservice._04._RetentionPolicy;
import ms.tfs.build.buildservice._04._Schedule;
import ms.tfs.services.linking._03._Artifact;
import ms.tfs.services.linking._03._ExtendedAttribute;

public class BuildDefinition
extends WebServiceObjectWrapper
implements IBuildDefinition {
    private IBuildController buildController;
    private IBuildServer buildServer;
    private String id;
    private String name;
    private String teamProject;
    private AttachedPropertyDictionary attachedProperties;
    private List<IRetentionPolicy> retentionPolicyList;
    private List<ISchedule> scheduleList;
    private List<BuildDefinitionSourceProvider> sourceProviders;
    private String configurationFolderPath;
    private String configurationFolderURI;
    private static final String CONFIGURATION_FOLDER_PATH = "ConfigurationFolderPath";

    public BuildDefinition(IBuildServer buildServer, _BuildDefinition webServiceObject) {
        super(webServiceObject);
        Check.notNull(buildServer, "buildServer");
        this.buildServer = buildServer;
        this.afterDeserialize();
    }

    public BuildDefinition(IBuildServer buildServer, String teamProject) {
        super(new _BuildDefinition());
        Check.notNull(buildServer, "buildServer");
        Check.notNull(teamProject, "teamProject");
        this.buildServer = buildServer;
        this.teamProject = teamProject;
        this.getWebServiceObject().setQueueStatus(DefinitionQueueStatus.ENABLED.getWebServiceObject());
        this.attachedProperties = new AttachedPropertyDictionary();
    }

    public BuildDefinition(IBuildServer buildServer, BuildDefinition2010 definition) {
        super(new _BuildDefinition());
        Check.notNull(buildServer, "buildServer");
        Check.notNull(definition, "definition");
        this.buildServer = buildServer;
        _BuildDefinition _o = this.getWebServiceObject();
        this.setBatchSize(1);
        if (definition.getBuildControllerURI() == null) {
            this.setBuildControllerURI(definition.getDefaultBuildAgentURI());
        } else {
            this.setBuildControllerURI(definition.getBuildControllerURI());
        }
        this.setContinuousIntegrationQuietPeriod(definition.getContinuousIntegrationQuietPeriod());
        this.setTriggerType(TFS2010Helper.convert(definition.getContinuousIntegrationType()));
        this.setDefaultDropLocation(definition.getDefaultDropLocation());
        this.setDescription(definition.getDescription());
        if (definition.isEnabled()) {
            this.setQueueStatus(DefinitionQueueStatus.ENABLED);
        } else {
            this.setQueueStatus(DefinitionQueueStatus.DISABLED);
        }
        this.setFullPath(definition.getWebServiceObject().getFullPath());
        _o.setLastBuildUri(definition.getLastBuildURI());
        _o.setLastGoodBuildLabel(definition.getLastGoodBuildLabel());
        _o.setLastGoodBuildUri(definition.getLastGoodBuildURI());
        this.setProcess(TFS2010Helper.convert(buildServer, definition.getProcess()));
        this.setProcessParameters(definition.getProcessParameters());
        this.setRetentionPolicies(TFS2010Helper.convert(this, definition.getRetentionPolicies()));
        this.setSchedules(TFS2010Helper.convert(this, definition.getSchedules()));
        this.teamProject = definition.getTeamProject();
        this.setURI(definition.getURI());
        this.setWorkspace(TFS2010Helper.convert(definition.getWorkspaceTemplate()));
        if (buildServer.getBuildServerVersion().isV2()) {
            this.configurationFolderURI = definition.getConfigurationFolderURI();
        }
        this.afterDeserialize();
    }

    private void afterDeserialize() {
        PropertyValue[] properties;
        this.setFullPath(this.getWebServiceObject().getFullPath());
        IRetentionPolicy[] policies = (IRetentionPolicy[])WrapperUtils.wrap(RetentionPolicy.class, this.getWebServiceObject().getRetentionPolicies());
        this.retentionPolicyList = new ArrayList<IRetentionPolicy>();
        if (policies != null) {
            for (IRetentionPolicy policy : policies) {
                this.retentionPolicyList.add(policy);
            }
        }
        this.attachedProperties = (properties = (PropertyValue[])WrapperUtils.wrap(PropertyValue.class, this.getWebServiceObject().getProperties())) == null ? new AttachedPropertyDictionary() : new AttachedPropertyDictionary(properties);
    }

    public _BuildDefinition getWebServiceObject() {
        return (_BuildDefinition)this.webServiceObject;
    }

    @Override
    public int getBatchSize() {
        return this.getWebServiceObject().getBatchSize();
    }

    @Override
    public void setBatchSize(int value) {
        this.getWebServiceObject().setBatchSize(value);
    }

    @Override
    public String getBuildControllerURI() {
        return this.getWebServiceObject().getBuildControllerUri();
    }

    public void setBuildControllerURI(String value) {
        this.getWebServiceObject().setBuildControllerUri(value);
    }

    @Override
    public int getContinuousIntegrationQuietPeriod() {
        return this.getWebServiceObject().getContinuousIntegrationQuietPeriod();
    }

    @Override
    public void setContinuousIntegrationQuietPeriod(int value) {
        this.getWebServiceObject().setContinuousIntegrationQuietPeriod(value);
    }

    @Override
    public Calendar getDateCreated() {
        return this.getWebServiceObject().getDateCreated();
    }

    @Override
    public String getDefaultDropLocation() {
        return this.getWebServiceObject().getDefaultDropLocation();
    }

    @Override
    public void setDefaultDropLocation(String value) {
        this.getWebServiceObject().setDefaultDropLocation(value);
    }

    @Override
    public String getDescription() {
        return this.getWebServiceObject().getDescription();
    }

    @Override
    public void setDescription(String value) {
        this.getWebServiceObject().setDescription(value);
    }

    public PropertyValue[] getInternalProperties() {
        return (PropertyValue[])WrapperUtils.wrap(PropertyValue.class, this.getWebServiceObject().getProperties());
    }

    public void setInternalProperties(PropertyValue[] value) {
        this.getWebServiceObject().setProperties((_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, value));
    }

    @Override
    public String getLastBuildURI() {
        return this.getWebServiceObject().getLastBuildUri();
    }

    @Override
    public String getLastGoodBuildLabel() {
        return this.getWebServiceObject().getLastGoodBuildLabel();
    }

    @Override
    public String getLastGoodBuildURI() {
        return this.getWebServiceObject().getLastGoodBuildUri();
    }

    @Override
    public DefinitionQueueStatus getQueueStatus() {
        return DefinitionQueueStatus.fromWebServiceObject(this.getWebServiceObject().getQueueStatus());
    }

    @Override
    public void setQueueStatus(DefinitionQueueStatus value) {
        this.getWebServiceObject().setQueueStatus(value.getWebServiceObject());
    }

    @Override
    public DefinitionTriggerType getTriggerType() {
        return new DefinitionTriggerType(this.getWebServiceObject().getTriggerType());
    }

    @Override
    public void setTriggerType(DefinitionTriggerType value) {
        this.getWebServiceObject().setTriggerType(value.getWebServiceObject());
    }

    @Override
    public String getURI() {
        return this.getWebServiceObject().getUri();
    }

    public void setURI(String value) {
        this.getWebServiceObject().setUri(value);
    }

    @Override
    public String getTeamProject() {
        return this.teamProject;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        this.name = value;
        this.setFullPath(this.getFullPath());
    }

    @Override
    public String getFullPath() {
        StringBuilder sb = new StringBuilder();
        sb.append("\\");
        sb.append(this.getTeamProject());
        sb.append("\\");
        sb.append(this.getName());
        return sb.toString();
    }

    public void setFullPath(String value) {
        this.getWebServiceObject().setFullPath(value);
        if (StringUtil.isNullOrEmpty(value)) {
            this.teamProject = "";
            this.name = "";
        } else {
            this.teamProject = BuildPath.getTeamProject(value);
            this.name = BuildPath.getItemName(value);
        }
    }

    @Override
    public IBuildServer getBuildServer() {
        return this.buildServer;
    }

    public void setBuildServer(IBuildServer value) {
        this.buildServer = value;
    }

    @Override
    public IBuildController getBuildController() {
        return this.buildController;
    }

    @Override
    public void setBuildController(IBuildController value) {
        this.buildController = value;
        if (this.buildController == null) {
            this.getWebServiceObject().setBuildControllerUri(null);
        } else {
            this.getWebServiceObject().setBuildControllerUri(this.buildController.getURI());
        }
    }

    @Override
    public String getID() {
        if (this.id == null && this.getURI() != null) {
            ArtifactID artifactID = new ArtifactID(this.getURI());
            this.id = artifactID.getToolSpecificID();
        }
        return this.id;
    }

    @Override
    public IRetentionPolicy[] getRetentionPolicies() {
        if (this.retentionPolicyList == null) {
            this.retentionPolicyList = new ArrayList<IRetentionPolicy>();
            if (this.buildServer.getBuildServerVersion().isV3OrGreater()) {
                DeleteOptions options = DeleteOptions.ALL.remove(DeleteOptions.TEST_RESULTS);
                this.retentionPolicyList.add(new RetentionPolicy(this, BuildReason.TRIGGERED, BuildStatus.FAILED, 10, options));
                this.retentionPolicyList.add(new RetentionPolicy(this, BuildReason.TRIGGERED, BuildStatus.PARTIALLY_SUCCEEDED, 10, options));
                this.retentionPolicyList.add(new RetentionPolicy(this, BuildReason.TRIGGERED, BuildStatus.STOPPED, 1, options));
                this.retentionPolicyList.add(new RetentionPolicy(this, BuildReason.TRIGGERED, BuildStatus.SUCCEEDED, 10, options));
                this.retentionPolicyList.add(new RetentionPolicy(this, BuildReason.VALIDATE_SHELVESET, BuildStatus.FAILED, 10, options));
                this.retentionPolicyList.add(new RetentionPolicy(this, BuildReason.VALIDATE_SHELVESET, BuildStatus.PARTIALLY_SUCCEEDED, 10, options));
                this.retentionPolicyList.add(new RetentionPolicy(this, BuildReason.VALIDATE_SHELVESET, BuildStatus.STOPPED, 1, options));
                this.retentionPolicyList.add(new RetentionPolicy(this, BuildReason.VALIDATE_SHELVESET, BuildStatus.SUCCEEDED, 10, options));
            } else if (this.getBuildServer().getBuildServerVersion().isV2()) {
                this.retentionPolicyList.add(new RetentionPolicy(this, BuildReason.ALL, BuildStatus.FAILED, Integer.MAX_VALUE, DeleteOptions.ALL));
                this.retentionPolicyList.add(new RetentionPolicy(this, BuildReason.ALL, BuildStatus.PARTIALLY_SUCCEEDED, Integer.MAX_VALUE, DeleteOptions.ALL));
                this.retentionPolicyList.add(new RetentionPolicy(this, BuildReason.ALL, BuildStatus.STOPPED, Integer.MAX_VALUE, DeleteOptions.ALL));
                this.retentionPolicyList.add(new RetentionPolicy(this, BuildReason.ALL, BuildStatus.SUCCEEDED, Integer.MAX_VALUE, DeleteOptions.ALL));
            }
        }
        return this.retentionPolicyList.toArray(new IRetentionPolicy[this.retentionPolicyList.size()]);
    }

    public void setRetentionPolicies(RetentionPolicy[] value) {
        _RetentionPolicy[] _policies = (_RetentionPolicy[])WrapperUtils.unwrap(_RetentionPolicy.class, value);
        this.getWebServiceObject().setRetentionPolicies(_policies);
    }

    @Override
    public ISchedule[] getSchedules() {
        if (this.scheduleList == null) {
            this.scheduleList = new ArrayList<ISchedule>();
            ISchedule[] schedules = (ISchedule[])WrapperUtils.wrap(Schedule.class, this.getWebServiceObject().getSchedules());
            if (schedules != null) {
                for (ISchedule schedule : schedules) {
                    this.scheduleList.add(schedule);
                }
            }
        }
        return this.scheduleList.toArray(new ISchedule[this.scheduleList.size()]);
    }

    public void setSchedules(Schedule[] value) {
        _Schedule[] _schedules = (_Schedule[])WrapperUtils.unwrap(_Schedule.class, value);
        this.getWebServiceObject().setSchedules(_schedules);
    }

    @Override
    public IWorkspaceTemplate getWorkspace() {
        if (this.getWebServiceObject().getWorkspaceTemplate() == null) {
            WorkspaceTemplate template = new WorkspaceTemplate();
            this.getWebServiceObject().setWorkspaceTemplate(template.getWebServiceObject());
        }
        return new WorkspaceTemplate(this.getWebServiceObject().getWorkspaceTemplate());
    }

    public void setWorkspace(IWorkspaceTemplate value) {
        if (value == null) {
            this.getWebServiceObject().setWorkspaceTemplate(null);
        } else {
            WorkspaceTemplate template = (WorkspaceTemplate)value;
            this.getWebServiceObject().setWorkspaceTemplate(template.getWebServiceObject());
        }
    }

    @Override
    public BuildDefinitionSourceProvider getDefaultSourceProvider() {
        BuildDefinitionSourceProvider[] providers = this.getSourceProviders();
        if (providers != null && providers.length > 0) {
            return providers[0];
        }
        return new BuildDefinitionSourceProvider();
    }

    @Override
    public void setDefaultSourceProvider(BuildDefinitionSourceProvider provider) {
        BuildDefinitionSourceProvider[] providers = new BuildDefinitionSourceProvider[]{provider};
        this.setSourceProviders(providers);
    }

    @Override
    public BuildDefinitionSourceProvider[] getSourceProviders() {
        if (this.sourceProviders == null) {
            this.sourceProviders = new ArrayList<BuildDefinitionSourceProvider>();
            BuildDefinitionSourceProvider[] providers = (BuildDefinitionSourceProvider[])WrapperUtils.wrap(BuildDefinitionSourceProvider.class, this.getWebServiceObject().getSourceProviders());
            if (providers != null) {
                for (BuildDefinitionSourceProvider provider : providers) {
                    this.sourceProviders.add(provider);
                }
            }
        }
        return this.sourceProviders.toArray(new BuildDefinitionSourceProvider[this.sourceProviders.size()]);
    }

    public void setSourceProviders(BuildDefinitionSourceProvider[] value) {
        _BuildDefinitionSourceProvider[] _providers = (_BuildDefinitionSourceProvider[])WrapperUtils.unwrap(_BuildDefinitionSourceProvider.class, value);
        this.getWebServiceObject().setSourceProviders(_providers);
    }

    @Override
    public ProcessTemplate getProcess() {
        _ProcessTemplate process = this.getWebServiceObject().getProcess();
        return process == null ? null : new ProcessTemplate(this.buildServer, process);
    }

    @Override
    public void setProcess(IProcessTemplate value) {
        if (value == null) {
            this.getWebServiceObject().setProcess(null);
        } else {
            ProcessTemplate template = (ProcessTemplate)value;
            this.getWebServiceObject().setProcess(template.getWebServiceObject());
        }
    }

    @Override
    public String getProcessParameters() {
        String processParameters = this.getWebServiceObject().getProcessParameters();
        if (processParameters == null && this.configurationFolderURI != null) {
            String configurationFolderPath = this.getConfigurationFolderPath();
            if (configurationFolderPath != null) {
                Properties parameters = new Properties();
                parameters.put(CONFIGURATION_FOLDER_PATH, configurationFolderPath);
                processParameters = XamlHelper.save(parameters);
            } else {
                processParameters = "";
            }
        }
        return processParameters;
    }

    @Override
    public void setProcessParameters(String value) {
        this.getWebServiceObject().setProcessParameters(value);
    }

    @Override
    public ContinuousIntegrationType getContinuousIntegrationType() {
        return TFS2010Helper.convert(new DefinitionTriggerType(this.getWebServiceObject().getTriggerType()));
    }

    @Override
    public void setContinuousIntegrationType(ContinuousIntegrationType value) {
        this.getWebServiceObject().setTriggerType(TFS2010Helper.convert(value).getWebServiceObject());
    }

    @Override
    public boolean isEnabled() {
        return this.getQueueStatus().equals(DefinitionQueueStatus.ENABLED) || this.getQueueStatus().equals(DefinitionQueueStatus.PAUSED);
    }

    @Override
    public void setEnabled(boolean value) {
        this.setQueueStatus(value ? DefinitionQueueStatus.ENABLED : DefinitionQueueStatus.DISABLED);
    }

    @Override
    public ISchedule addSchedule() {
        if (this.getSchedules().length != 0) {
            String format = Messages.getString("BuildDefinition2012.ScheduleNotSupportedFormat");
            String message = MessageFormat.format(format, this.getName());
            throw new NotSupportedException(message);
        }
        Schedule schedule = new Schedule(this);
        this.scheduleList.add(schedule);
        return schedule;
    }

    @Override
    public IRetentionPolicy addRetentionPolicy(BuildReason reason, BuildStatus status, int numberToKeep, DeleteOptions deleteOptions) {
        throw new NotSupportedException();
    }

    @Override
    public IBuildRequest createBuildRequest() {
        return new BuildRequest(this);
    }

    @Override
    public void delete() {
        if (this.getURI() != null) {
            this.buildServer.deleteBuildDefinitions(new IBuildDefinition[]{this});
        }
    }

    @Override
    public void save() {
        this.buildServer.saveBuildDefinitions(new IBuildDefinition[]{this});
    }

    public void prepareToSave() {
        BuildValidation.checkValidDefinitionName(this.name);
        this.getWebServiceObject().setFullPath(BuildPath.root(this.teamProject, this.name));
        Object[] policies = this.getRetentionPolicies();
        this.getWebServiceObject().setRetentionPolicies((_RetentionPolicy[])WrapperUtils.unwrap(_RetentionPolicy.class, policies));
        Object[] schedules = this.getSchedules();
        this.getWebServiceObject().setSchedules((_Schedule[])WrapperUtils.unwrap(_Schedule.class, schedules));
        if (this.getURI() == null && this.getWorkspace().getMappings().length == 0) {
            this.getWorkspace().map("$/" + this.getTeamProject(), "$(SourceDir)");
        }
        if (!this.getTriggerType().contains(DefinitionTriggerType.BATCHED_CONTINUOUS_INTEGRATION)) {
            this.setContinuousIntegrationQuietPeriod(0);
        }
        if (!this.getTriggerType().contains(DefinitionTriggerType.BATCHED_GATED_CHECKIN)) {
            this.getWebServiceObject().setBatchSize(1);
        }
        if (this.buildServer.getBuildServerVersion().isV3OrGreater() && this.configurationFolderPath != null && this.configurationFolderPath.trim().length() > 0) {
            Properties properties = new Properties();
            properties.setProperty(CONFIGURATION_FOLDER_PATH, this.configurationFolderPath);
            if (this.getProcessParameters() == null) {
                this.getWebServiceObject().setProcessParameters(XamlHelper.save(properties));
            } else {
                this.getWebServiceObject().setProcessParameters(XamlHelper.updateProperties(this.getWebServiceObject().getProcessParameters(), properties));
            }
        }
        _PropertyValue[] props = (_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, this.attachedProperties.getChangedProperties());
        this.getWebServiceObject().setProperties(props);
    }

    @Override
    public IBuildDefinitionSpec createSpec() {
        return this.buildServer.createBuildDefinitionSpec(this);
    }

    @Override
    public IBuildDetail[] queryBuilds() {
        return this.buildServer.queryBuilds(this);
    }

    @Override
    public IBuildDetail createManualBuild(String buildNumber) {
        return this.createManualBuild(buildNumber, null, BuildStatus.IN_PROGRESS, null, null);
    }

    @Override
    public IBuildDetail createManualBuild(String buildNumber, String dropLocation) {
        return this.createManualBuild(buildNumber, dropLocation, BuildStatus.IN_PROGRESS, null, null);
    }

    @Override
    public IBuildDetail createManualBuild(String buildNumber, String dropLocation, BuildStatus buildStatus, IBuildController controller, String requestedFor) {
        throw new NotSupportedException();
    }

    public VersionControlClient getVersionControl() {
        return this.buildServer.getConnection().getVersionControlClient();
    }

    public String getConfigurationFolderUri(String configurationFolderPath) {
        if (StringUtil.isNullOrEmpty(configurationFolderPath)) {
            return null;
        }
        ItemSet itemSet = this.getVersionControl().getItems(new ItemSpec(configurationFolderPath, RecursionType.NONE, 0), (VersionSpec)LatestVersionSpec.INSTANCE, DeletedState.NON_DELETED, ItemType.FOLDER, GetItemsOptions.NONE);
        if (itemSet.getItems().length == 0) {
            throw new ConfigurationFolderPathNotFoundException(configurationFolderPath);
        }
        ArtifactID artifact = new ArtifactID("VersionControl", "LatestItemVersion", String.valueOf(itemSet.getItems()[0].getItemID()));
        return artifact.encodeURI();
    }

    public AttachedPropertyDictionary getAttachedProperties() {
        return this.attachedProperties;
    }

    public void setAttachedProperties(AttachedPropertyDictionary value) {
        this.attachedProperties = value;
    }

    @Override
    public String getConfigurationFolderPath() {
        if (this.configurationFolderPath == null && this.buildServer.getBuildServerVersion().isV3OrGreater() && this.getProcessParameters() != null) {
            Properties props = XamlHelper.loadPartial(this.getProcessParameters());
            this.configurationFolderPath = props.getProperty(CONFIGURATION_FOLDER_PATH);
        }
        if (this.configurationFolderPath == null && this.configurationFolderURI != null) {
            LinkingClient linkingClient = (LinkingClient)this.buildServer.getConnection().getClient(LinkingClient.class);
            _Artifact[] artifacts = linkingClient.getArtifacts(new String[]{this.configurationFolderURI});
            _Artifact artifact = artifacts[0];
            _ExtendedAttribute[] attributes = artifact.getExtendedAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                if (!attributes[i].getName().equals("ServerPath")) continue;
                this.configurationFolderPath = attributes[i].getValue();
                return this.configurationFolderPath;
            }
            throw new ConfigurationFolderPathNotFoundException(MessageFormat.format(Messages.getString("BuildDefinition.ItemWasNotFoundInSourceControlFormat"), this.configurationFolderURI));
        }
        return this.configurationFolderPath;
    }

    @Override
    public void setConfigurationFolderPath(String value) {
        this.configurationFolderPath = value;
    }

    @Override
    public int hashCode() {
        if (this.getURI() == null) {
            return 0;
        }
        return this.getURI().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BuildDefinition)) {
            return false;
        }
        BuildDefinition other = (BuildDefinition)obj;
        if (this.getURI() == null) {
            if (other.getURI() != null) {
                return false;
            }
            if (!this.stringEquals(this.getTeamProject(), other.getTeamProject())) {
                return false;
            }
            return this.stringEquals(this.getName(), other.getName());
        }
        return this.getURI().equals(other.getURI());
    }

    private boolean stringEquals(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    @Override
    public void refresh() {
        throw new NotSupportedException();
    }
}

