/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.IBuildDefinition;
import com.microsoft.tfs.core.clients.build.IBuildDefinitionQueryResult;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IFailure;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildAgent;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildController;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinition;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServiceHost;
import com.microsoft.tfs.core.clients.build.internal.utils.BuildTypeConvertor;
import com.microsoft.tfs.core.clients.build.internal.utils.QueryResultHelper;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import java.util.Map;
import ms.tfs.build.buildservice._04._BuildAgent;
import ms.tfs.build.buildservice._04._BuildController;
import ms.tfs.build.buildservice._04._BuildDefinition;
import ms.tfs.build.buildservice._04._BuildDefinitionQueryResult;
import ms.tfs.build.buildservice._04._BuildServiceHost;

public class BuildDefinitionQueryResult
extends WebServiceObjectWrapper
implements IBuildDefinitionQueryResult {
    private final BuildDefinition[] definitions;
    private final BuildAgent[] agents;
    private final BuildController[] controllers;
    private final BuildServiceHost[] serviceHosts;

    public BuildDefinitionQueryResult(IBuildServer buildServer, _BuildDefinitionQueryResult webServiceObject) {
        super(webServiceObject);
        Check.notNull(buildServer, "buildServer");
        this.serviceHosts = BuildTypeConvertor.toBuildServiceHostArray(buildServer, this.getWebServiceObject().getServiceHosts());
        this.controllers = BuildTypeConvertor.toBuildControllersArray(buildServer, this.getWebServiceObject().getControllers());
        this.agents = BuildTypeConvertor.toBuildAgentArray(this.getWebServiceObject().getAgents());
        this.definitions = BuildTypeConvertor.toBuildDefinitionArray(buildServer, this.getWebServiceObject().getDefinitions());
        this.afterDeserialize(buildServer);
    }

    public BuildDefinitionQueryResult(IBuildServer buildServer, BuildAgent[] agents, BuildController[] controllers, BuildDefinition[] definitions, BuildServiceHost[] serviceHosts) {
        super(new _BuildDefinitionQueryResult());
        Check.notNull(buildServer, "buildServer");
        Check.notNull(agents, "agents");
        Check.notNull(controllers, "controllers");
        Check.notNull(definitions, "definitions");
        Check.notNull(serviceHosts, "serviceHosts");
        this.agents = agents;
        this.controllers = controllers;
        this.definitions = definitions;
        this.serviceHosts = serviceHosts;
        _BuildAgent[] _agents = (_BuildAgent[])WrapperUtils.unwrap(_BuildAgent.class, agents);
        _BuildController[] _controllers = (_BuildController[])WrapperUtils.unwrap(_BuildController.class, controllers);
        _BuildDefinition[] _definitions = (_BuildDefinition[])WrapperUtils.unwrap(_BuildDefinition.class, definitions);
        _BuildServiceHost[] _serviceHosts = (_BuildServiceHost[])WrapperUtils.unwrap(_BuildServiceHost.class, serviceHosts);
        this.getWebServiceObject().setAgents(_agents);
        this.getWebServiceObject().setControllers(_controllers);
        this.getWebServiceObject().setDefinitions(_definitions);
        this.getWebServiceObject().setServiceHosts(_serviceHosts);
        this.afterDeserialize(buildServer);
    }

    public _BuildDefinitionQueryResult getWebServiceObject() {
        return (_BuildDefinitionQueryResult)this.webServiceObject;
    }

    @Override
    public IBuildDefinition[] getDefinitions() {
        return this.definitions;
    }

    @Override
    public IFailure[] getFailures() {
        return new IFailure[0];
    }

    private void afterDeserialize(IBuildServer buildServer) {
        Map<String, BuildController> controllerDict = QueryResultHelper.match(this.serviceHosts, this.controllers, this.agents);
        for (BuildDefinition definition : this.definitions) {
            BuildController controller;
            if (definition == null || definition.getBuildControllerURI() == null || (controller = controllerDict.get(definition.getBuildControllerURI())) == null) continue;
            definition.setBuildController(controller);
        }
    }
}

