/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.utils;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.util.StringUtil;
import com.microsoft.tfs.util.xml.DOMCreateUtils;
import com.microsoft.tfs.util.xml.DOMSerializeUtils;
import com.microsoft.tfs.util.xml.DOMUtils;
import com.microsoft.tfs.util.xml.XMLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XamlHelper {
    private static final Log log = LogFactory.getLog(XamlHelper.class);
    private static final String XAML_NAMESPACE = "http://schemas.microsoft.com/winfx/2006/xaml";
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String NEWLINE = System.getProperty("line.separator");

    public static String save(Properties properties) {
        StringBuffer xaml = new StringBuffer();
        xaml.append("<Dictionary x:TypeArguments=\"x:String, x:Object\" xmlns=\"clr-namespace:System.Collections.Generic;assembly=mscorlib\" xmlns:x=\"http://schemas.microsoft.com/winfx/2006/xaml\">");
        xaml.append(NEWLINE);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String name = XamlHelper.escapeValue((String)entry.getKey());
            String value = XamlHelper.escapeValue((String)entry.getValue());
            xaml.append("    <x:String x:Key=\"");
            xaml.append(name);
            xaml.append("\" xml:space=\"preserve\">");
            xaml.append(value);
            xaml.append("</x:String>");
            xaml.append(NEWLINE);
        }
        xaml.append("</Dictionary>");
        return xaml.toString();
    }

    private static String escapeValue(String rawString) {
        String escaped = rawString;
        escaped = StringUtil.replace(escaped, "&", "&amp;");
        escaped = StringUtil.replace(escaped, "<", "&lt;");
        escaped = StringUtil.replace(escaped, ">", "&gt;");
        escaped = StringUtil.replace(escaped, "'", "&apos;");
        escaped = StringUtil.replace(escaped, "\"", "&quot;");
        return escaped;
    }

    public static String updateProperties(String originalXaml, Properties properties) {
        ArrayList<Object> keys = new ArrayList<Object>(properties.keySet());
        Document document = DOMCreateUtils.parseString(originalXaml);
        Element root = document.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("x:String");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            String key = element.getAttribute("x:Key");
            element.getFirstChild().getNodeValue();
            if (!properties.containsKey(key)) continue;
            keys.remove(key);
            element.getFirstChild().setNodeValue(properties.getProperty(key));
        }
        for (String string : keys) {
            Element element = DOMUtils.appendChild(root, "x:String");
            element.setAttributeNS(XAML_NAMESPACE, "x:Key", string);
            element.setAttributeNS(XML_NAMESPACE, "xml:space", "preserve");
            DOMUtils.appendText(element, properties.getProperty(string));
        }
        return DOMSerializeUtils.toString(root, 2).trim();
    }

    public static Properties loadPartial(String xaml) {
        Properties properties = new Properties();
        try {
            Document document = DOMCreateUtils.parseString(xaml);
            Element root = document.getDocumentElement();
            NodeList nodes = root.getElementsByTagName("x:String");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element = (Element)nodes.item(i);
                String key = element.getAttribute("x:Key");
                String value = element.getFirstChild().getNodeValue();
                properties.put(key, value);
            }
        }
        catch (XMLException e) {
            log.error((Object)MessageFormat.format(Messages.getString("XamlHelper.ExceptionParsingProcessParaemtersFormat"), xaml), (Throwable)e);
        }
        return properties;
    }
}

