/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.catalog;

import com.microsoft.tfs.core.clients.framework.catalog.CatalogNode;
import com.microsoft.tfs.core.clients.framework.configuration.TFSEntity;
import com.microsoft.tfs.core.clients.framework.configuration.TFSEntitySession;
import com.microsoft.tfs.core.clients.framework.configuration.internal.TFSCatalogEntitySession;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class TFSCatalogEntity
implements TFSEntity {
    private final TFSCatalogEntitySession session;
    private final CatalogNode catalogNode;
    private final Object lock = new Object();
    private boolean parentLoaded = false;
    private TFSEntity parent;
    private List<TFSEntity> children;
    private boolean dependenciesLoaded = false;
    private HashMap<String, TFSEntity> dependencySingletonMap;
    private HashMap<String, List<TFSEntity>> dependencySetMap;
    private List<TFSEntity> dependencyList;

    public TFSCatalogEntity(TFSCatalogEntitySession session, CatalogNode catalogNode) {
        Check.notNull(session, "session");
        Check.notNull(catalogNode, "catalogNode");
        this.session = session;
        this.catalogNode = catalogNode;
    }

    protected TFSEntitySession getSession() {
        return this.session;
    }

    public CatalogNode getCatalogNode() {
        return this.catalogNode;
    }

    @Override
    public GUID getResourceID() {
        return new GUID(this.catalogNode.getResource().getResourceTypeIdentifier());
    }

    @Override
    public String getDisplayName() {
        return this.catalogNode.getResource().getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.catalogNode.getResource().getDescription();
    }

    public String getProperty(String propertyName) {
        Check.notNull(propertyName, "propertyName");
        return this.catalogNode.getResource().getProperties().get(propertyName);
    }

    @Override
    public String getDisplayPath() {
        StringBuffer displayPath = new StringBuffer();
        if (this.parent != null) {
            displayPath.append(this.parent.getDisplayPath());
        }
        displayPath.append("\\");
        if (this.getDisplayName() != null) {
            displayPath.append(this.getDisplayName());
        }
        return displayPath.toString();
    }

    public void setParent(TFSEntity parent) {
        this.parent = parent;
        this.parentLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TFSEntity getParent() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.parentLoaded) {
                this.parent = this.session.loadParent(this);
                this.parentLoaded = true;
            }
            return this.parent;
        }
    }

    public <T extends TFSEntity> T getAncestorOfType(Class<T> type) {
        Check.notNull(type, "type");
        for (TFSEntity ancestor = this.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (!type.isInstance(ancestor)) continue;
            return (T)ancestor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TFSEntity> getChildrenList() {
        Object object = this.lock;
        synchronized (object) {
            if (this.children == null) {
                this.children = this.session.loadChildren(this);
            }
            return this.children;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFSEntity[] getChildren() {
        Object object = this.lock;
        synchronized (object) {
            List<TFSEntity> childrenList = this.getChildrenList();
            return childrenList.toArray(new TFSEntity[childrenList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends TFSEntity> T[] getChildrenOfType(Class<T> type) {
        Check.notNull(type, "type");
        Object object = this.lock;
        synchronized (object) {
            return TFSCatalogEntity.getTypedList(this.getChildrenList(), type);
        }
    }

    public <T extends TFSEntity> T getChildOfType(Class<T> type) {
        TFSEntity[] children = this.getChildrenOfType(type);
        if (children.length == 1) {
            return (T)children[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadDependencies() {
        Object object = this.lock;
        synchronized (object) {
            if (this.dependenciesLoaded) {
                return false;
            }
            this.dependencySingletonMap = new HashMap();
            this.dependencySetMap = new HashMap();
            this.dependencyList = new ArrayList<TFSEntity>();
            this.session.loadDependencies(this, this.dependencySingletonMap, this.dependencySetMap, this.dependencyList);
            this.dependenciesLoaded = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFSEntity getSingletonDependency(String key) {
        Object object = this.lock;
        synchronized (object) {
            this.loadDependencies();
            return this.dependencySingletonMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TFSEntity[] getDependencies() {
        Object object = this.lock;
        synchronized (object) {
            this.loadDependencies();
            return this.dependencyList.toArray(new TFSEntity[this.dependencyList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends TFSEntity> T[] getDependenciesOfType(Class<T> type) {
        Check.notNull(type, "type");
        Object object = this.lock;
        synchronized (object) {
            this.loadDependencies();
            return TFSCatalogEntity.getTypedList(this.dependencyList, type);
        }
    }

    public <T extends TFSEntity> T getDependencyOfType(Class<T> type) {
        TFSEntity[] dependencies = this.getDependenciesOfType(type);
        if (dependencies.length == 1) {
            return (T)dependencies[0];
        }
        return null;
    }

    private static <T extends TFSEntity> T[] getTypedList(List<TFSEntity> list, Class<T> type) {
        Check.notNull(list, "list");
        Check.notNull(type, "type");
        ArrayList<TFSEntity> matchList = new ArrayList<TFSEntity>();
        for (TFSEntity object : list) {
            if (!type.isInstance(object)) continue;
            matchList.add(object);
        }
        return matchList.toArray((TFSEntity[])Array.newInstance(type, matchList.size()));
    }
}

