/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.linking;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.artifact.ArtifactID;
import com.microsoft.tfs.core.artifact.MalformedURIException;
import com.microsoft.tfs.core.clients.linking.exceptions.LinkingException;
import com.microsoft.tfs.core.clients.registration.RegistrationClient;
import com.microsoft.tfs.core.clients.registration.RegistrationEntry;
import com.microsoft.tfs.core.clients.registration.RegistrationExtendedAttribute;
import com.microsoft.tfs.core.clients.registration.ServiceInterface;
import com.microsoft.tfs.util.StringUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ms.tfs.services.linking._03._Artifact;
import ms.tfs.services.linking._03._IntegrationServiceSoap;

public class LinkingClient {
    private final TFSTeamProjectCollection connection;
    private static final String EXTERNAL_URL_HARDCODED_PART = ".aspx?artifactMoniker=";
    private Map<String, _IntegrationServiceSoap> artifactProviders;

    public LinkingClient(TFSTeamProjectCollection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private _IntegrationServiceSoap getLinkingSoap(String toolId) {
        LinkingClient linkingClient = this;
        synchronized (linkingClient) {
            if (this.artifactProviders == null) {
                this.artifactProviders = new HashMap<String, _IntegrationServiceSoap>();
                RegistrationEntry[] allRegistrationEntries = this.getRegistrationClient().getRegistrationEntries();
                for (int i = 0; i < allRegistrationEntries.length; ++i) {
                    String urlString = null;
                    ServiceInterface[] serviceInterfaces = allRegistrationEntries[i].getServiceInterfaces();
                    for (int j = 0; j < serviceInterfaces.length; ++j) {
                        if (!"LinkingProviderService".equalsIgnoreCase(serviceInterfaces[j].getName())) continue;
                        urlString = serviceInterfaces[j].getRelativeURL();
                        break;
                    }
                    if (StringUtil.isNullOrEmpty(urlString)) continue;
                    _IntegrationServiceSoap linkingService = this.connection.getLinkingWebService(urlString);
                    this.artifactProviders.put(allRegistrationEntries[i].getType(), linkingService);
                }
            }
        }
        return this.artifactProviders.get(toolId);
    }

    public _Artifact[] getArtifacts(String[] artifactUriList) throws MalformedURIException {
        if (artifactUriList == null) {
            return null;
        }
        for (int i = 0; i < artifactUriList.length; ++i) {
            ArtifactID.checkURIIsWellFormed(artifactUriList[i]);
        }
        return this.getArtifactsProcess(artifactUriList);
    }

    private _Artifact[] getArtifactsProcess(String[] artifactUriList) {
        HashMap<String, ArrayList<ArtifactID>> toolIdToArtifactIds = new HashMap<String, ArrayList<ArtifactID>>();
        for (int i = 0; i < artifactUriList.length; ++i) {
            ArtifactID artifactId = new ArtifactID(artifactUriList[i]);
            ArrayList<ArtifactID> artifactIds = (ArrayList<ArtifactID>)toolIdToArtifactIds.get(artifactId.getTool());
            if (artifactIds == null) {
                artifactIds = new ArrayList<ArtifactID>();
                toolIdToArtifactIds.put(artifactId.getTool(), artifactIds);
            }
            artifactIds.add(artifactId);
        }
        HashMap<String, _Artifact> artifactUriToArtifact = new HashMap<String, _Artifact>();
        for (String toolId : toolIdToArtifactIds.keySet()) {
            List artifactIdList;
            ArtifactID[] artifactIds;
            _Artifact[] artifacts = this.getArtifactsProcess(toolId, artifactIds = (artifactIdList = (List)toolIdToArtifactIds.get(toolId)).toArray(new ArtifactID[artifactIdList.size()]));
            if (artifacts == null || artifacts.length != artifactIds.length) {
                throw new LinkingException();
            }
            for (int i = 0; i < artifactIds.length; ++i) {
                artifactUriToArtifact.put(artifactIds[i].encodeURI(), artifacts[i]);
            }
        }
        _Artifact[] returnValue = new _Artifact[artifactUriList.length];
        for (int i = 0; i < artifactUriList.length; ++i) {
            returnValue[i] = (_Artifact)artifactUriToArtifact.get(artifactUriList[i]);
        }
        return returnValue;
    }

    private _Artifact[] getArtifactsProcess(String tool, ArtifactID[] artifactIds) {
        _Artifact[] artifacts = null;
        if (tool.equalsIgnoreCase("Requirements")) {
            artifacts = new _Artifact[artifactIds.length];
            for (int i = 0; i < artifactIds.length; ++i) {
                ArtifactID artifactId = artifactIds[i];
                artifacts[i] = new _Artifact();
                artifacts[i].setUri(artifactId.encodeURI());
                String format = Messages.getString("LinkingClient.StoryboardLinkDescriptionFormat");
                artifacts[i].setArtifactTitle(MessageFormat.format(format, artifactId.getToolSpecificID()));
            }
            return artifacts;
        }
        _IntegrationServiceSoap linkingService = this.getLinkingSoap(tool);
        if (linkingService != null) {
            String[] uris = new String[artifactIds.length];
            for (int i = 0; i < artifactIds.length; ++i) {
                uris[i] = artifactIds[i].encodeURI();
            }
            artifacts = linkingService.getArtifacts(uris);
        }
        return artifacts;
    }

    public String getArtifactURLExternal(ArtifactID id) {
        String displaySegment = null;
        RegistrationEntry entry = this.getRegistrationClient().getRegistrationEntry(id.getTool());
        RegistrationExtendedAttribute[] attributes = entry.getRegistrationExtendedAttributes();
        if (attributes != null) {
            for (int j = 0; j < attributes.length && StringUtil.isNullOrEmpty(displaySegment); ++j) {
                if (!attributes[j].getName().equals("ArtifactDisplayUrl")) continue;
                displaySegment = attributes[j].getValue();
            }
        }
        if (displaySegment != null) {
            displaySegment = displaySegment.trim();
        }
        StringBuffer url = new StringBuffer();
        url.append(this.connection.getURL());
        if (!StringUtil.isNullOrEmpty(displaySegment) && displaySegment.startsWith("/")) {
            url.append(displaySegment);
        }
        if (!url.toString().endsWith("/")) {
            url.append("/");
        }
        url.append(id.getTool());
        url.append("/");
        url.append(id.getArtifactType());
        url.append(EXTERNAL_URL_HARDCODED_PART);
        url.append(id.getToolSpecificID());
        return url.toString();
    }

    public String getArtifactURLExternal(String uri) {
        return this.getArtifactURLExternal(new ArtifactID(uri));
    }

    private RegistrationClient getRegistrationClient() {
        return this.connection.getRegistrationClient();
    }
}

