/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.conflicts;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.OperationStatus;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictCategory;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescriptionStrings;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.CoreConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.KeepLocalWritableConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.contributors.ConflictResolutionContributor;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Resolution;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import java.text.MessageFormat;
import java.util.ArrayList;

public final class WritableConflictDescription
extends ConflictDescription {
    protected WritableConflictDescription(Workspace workspace, Conflict conflict, ItemSpec[] conflictItemSpecs) {
        super(workspace, conflict, conflictItemSpecs);
    }

    @Override
    public ConflictCategory getConflictCategory() {
        return ConflictCategory.WRITABLE;
    }

    @Override
    public String getServerPath() {
        Conflict vcConflict = this.getConflict();
        if (vcConflict.getBaseServerItem() != null) {
            return vcConflict.getBaseServerItem();
        }
        if (vcConflict.getYourServerItem() != null) {
            return vcConflict.getYourServerItem();
        }
        return vcConflict.getTheirServerItem();
    }

    @Override
    public String getName() {
        return Messages.getString("WritableConflictDescription.Name");
    }

    @Override
    public String getDescription() {
        Conflict conflict = this.getConflict();
        if (conflict != null) {
            if (conflict.getBaseServerItem() != null) {
                return Messages.getString("WritableConflictDescription.DescriptionFileBySameNameExists");
            }
            if (conflict.getReason() == OperationStatus.TARGET_WRITABLE.getValue()) {
                return MessageFormat.format(Messages.getString("WritableConflictDescription.DescriptionLocalFileIsWritableFormat"), conflict.getTargetLocalItem());
            }
            if (conflict.getReason() == OperationStatus.SOURCE_WRITABLE.getValue()) {
                return MessageFormat.format(Messages.getString("WritableConflictDescription.DescriptionLocalFileIsWritableFormat"), conflict.getSourceLocalItem());
            }
        }
        return Messages.getString("WritableConflictDescription.DescriptionLocalFileIsWritable");
    }

    @Override
    public ConflictResolution[] getResolutions(ConflictResolutionContributor resolutionContributor) {
        ArrayList<CoreConflictResolution> resolutions = new ArrayList<CoreConflictResolution>();
        resolutions.add(new CoreConflictResolution(this, ConflictDescriptionStrings.OVERWRITE, ConflictDescriptionStrings.OVERWRITE_TOOLTIP, ConflictResolutionOptions.NONE, Resolution.OVERWRITE_LOCAL));
        Conflict conflict = this.getConflict();
        if (conflict != null && conflict.getReason() == OperationStatus.TARGET_WRITABLE.getValue()) {
            resolutions.add(new KeepLocalWritableConflictResolution(this, ConflictDescriptionStrings.KEEP_LOCAL, ConflictDescriptionStrings.KEEP_LOCAL_TOOLTIP));
        }
        return resolutions.toArray(new ConflictResolution[resolutions.size()]);
    }
}

