/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal;

import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.WebServiceLayer;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Changeset;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.microsoft.tfs.util.Check;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class HistoryIterator
implements Iterator<Changeset> {
    private static final int PAGE_SIZE = 256;
    private final WebServiceLayer webServiceLayer;
    private final String workspaceName;
    private final String workspaceOwner;
    private final ItemSpec itemSpec;
    private final VersionSpec versionItem;
    private final String user;
    private final VersionSpec versionFrom;
    private final boolean includeFiles;
    private final boolean generateDownloadUrls;
    private final boolean slotMode;
    private final boolean sortAscending;
    private VersionSpec endingVersionSpec;
    private int numLeft;
    private int numRequested = -1;
    private Changeset[] changesets;
    private int changesetsIndex = -1;

    public HistoryIterator(WebServiceLayer webServiceLayer, String workspaceName, String workspaceOwner, ItemSpec itemSpec, VersionSpec versionItem, String user, VersionSpec versionFrom, VersionSpec versionTo, int maxCount, boolean includefiles, boolean generateDownloadUrls, boolean slotMode, boolean sortAscending) {
        Check.notNull(webServiceLayer, "webServiceLayer");
        this.webServiceLayer = webServiceLayer;
        this.workspaceName = workspaceName;
        this.workspaceOwner = workspaceOwner;
        this.itemSpec = itemSpec;
        this.versionItem = versionItem;
        this.user = user;
        this.versionFrom = versionFrom;
        this.endingVersionSpec = versionTo;
        this.numLeft = maxCount;
        this.includeFiles = includefiles;
        this.generateDownloadUrls = generateDownloadUrls;
        this.slotMode = slotMode;
        this.sortAscending = sortAscending;
    }

    public void prime() {
        if (this.changesets != null) {
            throw new IllegalStateException();
        }
        this.pageIn();
    }

    @Override
    public boolean hasNext() {
        if (!this.currentPageHasNext() && this.areMorePages()) {
            this.pageIn();
        }
        return this.currentPageHasNext();
    }

    @Override
    public Changeset next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.changesets[this.changesetsIndex++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean currentPageHasNext() {
        return this.changesets != null && this.changesetsIndex < this.changesets.length;
    }

    private boolean areMorePages() {
        if (this.changesets == null) {
            return true;
        }
        if (this.changesets.length == 0) {
            return false;
        }
        if (this.changesets[this.changesets.length - 1].getChangesetID() == 1) {
            return false;
        }
        if (this.changesets.length < this.numRequested) {
            return false;
        }
        return this.numLeft != 0;
    }

    private void pageIn() throws VersionControlException {
        this.numRequested = Math.min(this.numLeft, 256);
        this.changesets = this.webServiceLayer.queryHistory(this.workspaceName, this.workspaceOwner, this.itemSpec, this.versionItem, this.user, this.versionFrom, this.endingVersionSpec, this.numRequested, this.includeFiles, this.generateDownloadUrls, this.slotMode, this.sortAscending);
        this.numLeft -= this.changesets.length;
        if (this.changesets.length > 0) {
            if (this.includeFiles) {
                for (Changeset set : this.changesets) {
                    set.sortChanges();
                }
            }
            int lastChangesetNumber = this.changesets[this.changesets.length - 1].getChangesetID();
            this.endingVersionSpec = new ChangesetVersionSpec(lastChangesetNumber - 1);
        }
        this.changesetsIndex = 0;
    }
}

