/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.AsyncOperation;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.BaselineDownloadAsyncOperation;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.BaselineUpdaterAsyncOperation;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.BaselineDownloadWorker;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.BaselineUpdaterWorker;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.WorkerStatus;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.CorruptBaselineException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.MissingBaselineException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.concurrent.AccountingCompletionService;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineFolderState;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineRequest;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.BaselineFolder;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.exceptions.internal.CoreCancelException;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.jni.helpers.FileCopyHelper;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.HashUtils;
import com.microsoft.tfs.util.IOUtils;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import com.microsoft.tfs.util.tasks.TaskMonitorService;
import com.microsoft.tfs.util.temp.TempStorageService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaselineFolderCollection {
    private static final Log log = LogFactory.getLog(BaselineFolderCollection.class);
    private static final String TMP_EXTENSION = ".tmp";
    private static final int DECOMPRESSION_BUFFER_SIZE = 4096;
    public static final int UNINITIALIZED_READ_LOCK_TOKEN = 0;
    private final TokenReaderWriterLock rwLock;
    private final Workspace workspace;
    private List<BaselineFolder> baselineFolders;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaselineFolderCollection(Workspace workspace, List<BaselineFolder> baselineFolders) {
        Check.notNull(workspace, "workspace");
        this.rwLock = new TokenReaderWriterLock();
        this.workspace = workspace;
        int token = this.rwLock.enterWriteLock();
        try {
            this.updateFrom(baselineFolders);
        }
        finally {
            this.rwLock.exitWriteLock(token);
        }
    }

    public int lockForRead() {
        return this.rwLock.enterReadLock();
    }

    public void unlockForRead(int token) {
        this.rwLock.exitReadLock(token);
    }

    public int lockForWrite() {
        return this.rwLock.enterWriteLock();
    }

    public void unlockForWrite(int token) {
        this.rwLock.exitWriteLock(token);
    }

    public void updateFrom(List<BaselineFolder> baselineFolders) {
        Check.notNull(baselineFolders, "baselineFolders");
        this.baselineFolders = new ArrayList<BaselineFolder>(baselineFolders.size());
        for (int i = 0; i < baselineFolders.size(); ++i) {
            this.baselineFolders.add(baselineFolders.get(i).clone());
        }
    }

    public String getNewBaselineLocation(byte[] baselineFileGuid, String targetLocalItem, int readLockToken) {
        Check.isTrue(readLockToken > 0, "readLockToken");
        return BaselineFolderCollection.getNewBaselineLocation(this.workspace, this.baselineFolders, baselineFileGuid, targetLocalItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isImmediateParentOfBaselineFolder(String sourceLocalItem) {
        Check.notEmpty(sourceLocalItem, "sourceLocalItem");
        int token = this.rwLock.enterReadLock();
        try {
            BaselineFolder baselineFolder = null;
            for (BaselineFolder bf : this.baselineFolders) {
                if (null == bf.path || !LocalPath.isDirectChild(bf.path, sourceLocalItem)) continue;
                baselineFolder = bf;
                break;
            }
            boolean bl = null != baselineFolder;
            return bl;
        }
        finally {
            this.rwLock.exitReadLock(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyBaselineToTarget(byte[] baselineFileGuid, String targetLocalItem, long baselineFileLength, byte[] baselineHashValue, boolean symlink) {
        int token = this.rwLock.enterReadLock();
        try {
            BaselineFolderCollection.copyBaselineToTarget(this.workspace, this.baselineFolders, baselineFileGuid, targetLocalItem, baselineFileLength, baselineHashValue, symlink);
        }
        finally {
            this.rwLock.exitReadLock(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBaseline(byte[] baselineFileGuid) {
        int token = this.rwLock.enterReadLock();
        try {
            BaselineFolderCollection.deleteBaseline(this.workspace, this.baselineFolders, baselineFileGuid);
        }
        finally {
            this.rwLock.exitReadLock(token);
        }
    }

    public static String getNewBaselineLocation(Workspace workspace, List<BaselineFolder> baselineFolders, byte[] baselineFileGuid, String targetLocalItem) {
        BaselineFolder.checkForValidBaselineFileGUID(baselineFileGuid);
        BaselineFolder baselineFolder = null;
        if (targetLocalItem != null && targetLocalItem.length() > 0) {
            baselineFolder = BaselineFolderCollection.getBaselineFolderForPartition(baselineFolders, BaselineFolder.getPartitionForPath(targetLocalItem));
        }
        if (null == baselineFolder && baselineFolders.size() > 0) {
            baselineFolder = baselineFolders.get(0);
        }
        AtomicReference<String> outIndividualBaselineFolder = new AtomicReference<String>();
        if (null == baselineFolder) {
            BaselineFolder.ensureLocalMetadataDirectoryExists(workspace);
            String toReturn = BaselineFolder.getPathFromGUID(workspace.getLocalMetadataDirectory(), baselineFileGuid, outIndividualBaselineFolder);
            File directory = new File(outIndividualBaselineFolder.get());
            if (!directory.exists()) {
                directory.mkdirs();
            }
            return toReturn;
        }
        BaselineFolder.ensureBaselineDirectoryExists(workspace, baselineFolder.getPath());
        String toReturn = BaselineFolder.getPathFromGUID(baselineFolder.getPath(), baselineFileGuid, outIndividualBaselineFolder);
        File directory = new File(outIndividualBaselineFolder.get());
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return toReturn;
    }

    public static String getBaselineLocation(Workspace workspace, List<BaselineFolder> baselineFolders, byte[] baselineFileGuid) {
        AtomicBoolean isBaselineCompressed = new AtomicBoolean();
        return BaselineFolderCollection.getBaselineLocation(workspace, baselineFolders, baselineFileGuid, isBaselineCompressed);
    }

    public static String getBaselineLocation(Workspace workspace, List<BaselineFolder> baselineFolders, byte[] baselineFileGuid, AtomicBoolean isBaselineCompressed) {
        String programDataLocation;
        BaselineFolder.checkForValidBaselineFileGUID(baselineFileGuid);
        isBaselineCompressed.set(false);
        String baselineLocation = null;
        for (BaselineFolder baselineFolder : baselineFolders) {
            String potentialLocation;
            if (null == baselineFolder.path || null == (potentialLocation = baselineFolder.getPathFromGUID(baselineFileGuid))) continue;
            String gzPotentialLocation = potentialLocation + BaselineFolder.getGzipExtension();
            if (new File(gzPotentialLocation).exists()) {
                isBaselineCompressed.set(true);
                baselineLocation = gzPotentialLocation;
                break;
            }
            String rawPotentialLocation = potentialLocation + BaselineFolder.getRawExtension();
            if (!new File(rawPotentialLocation).exists()) continue;
            baselineLocation = rawPotentialLocation;
            break;
        }
        if (null == baselineLocation && null != (programDataLocation = BaselineFolder.getPathFromGUID(workspace.getLocalMetadataDirectory(), baselineFileGuid))) {
            String rawProgramDataLocation;
            String gzProgramDataLocation = programDataLocation + BaselineFolder.getGzipExtension();
            if (new File(gzProgramDataLocation).exists()) {
                isBaselineCompressed.set(true);
                baselineLocation = gzProgramDataLocation;
            }
            if (null == baselineLocation && new File(rawProgramDataLocation = programDataLocation + BaselineFolder.getRawExtension()).exists()) {
                baselineLocation = rawProgramDataLocation;
            }
        }
        return baselineLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyBaselineToTarget(Workspace workspace, List<BaselineFolder> baselineFolders, byte[] baselineFileGuid, String targetLocalItem, long baselineFileLength, byte[] baselineHashValue, boolean symlink) {
        Check.notNullOrEmpty(targetLocalItem, "targetLocalItem");
        BaselineFolder.checkForValidBaselineFileGUID(baselineFileGuid);
        File file = new File(targetLocalItem);
        file.delete();
        AtomicBoolean outIsBaselineCompressed = new AtomicBoolean();
        String baselineLocation = BaselineFolderCollection.getBaselineLocation(workspace, baselineFolders, baselineFileGuid, outIsBaselineCompressed);
        if (null == baselineLocation) {
            throw new MissingBaselineException(targetLocalItem);
        }
        String decompressedBaselineLocation = baselineLocation;
        try {
            byte[] decompressedHashValue = null;
            boolean haveBaselineHashValue = null != baselineHashValue && 16 == baselineHashValue.length;
            MessageDigest md5Digest = null;
            if (haveBaselineHashValue) {
                md5Digest = MessageDigest.getInstance("MD5");
            }
            if (outIsBaselineCompressed.get()) {
                FileOutputStream outputStream;
                block23: {
                    decompressedBaselineLocation = LocalPath.combine(LocalPath.getParent(baselineLocation), GUID.newGUIDString()) + TMP_EXTENSION;
                    byte[] buffer = new byte[4096];
                    GZIPInputStream inputStream = null;
                    outputStream = null;
                    try {
                        int bytesRead;
                        inputStream = new GZIPInputStream(new FileInputStream(baselineLocation));
                        if (!symlink) {
                            outputStream = new FileOutputStream(decompressedBaselineLocation);
                        }
                        while ((bytesRead = ((InputStream)inputStream).read(buffer, 0, buffer.length)) >= 0) {
                            if (bytesRead == 0) continue;
                            if (null != md5Digest) {
                                md5Digest.update(buffer, 0, bytesRead);
                            }
                            if (symlink) {
                                String targetLink = new String(buffer, 0, bytesRead);
                                FileSystemUtils.getInstance().createSymbolicLink(targetLink, targetLocalItem);
                                continue;
                            }
                            ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                        }
                        if (null != md5Digest) {
                            decompressedHashValue = md5Digest.digest();
                        }
                        if (inputStream == null) break block23;
                    }
                    catch (Throwable throwable) {
                        if (inputStream != null) {
                            IOUtils.closeSafely(inputStream);
                        }
                        if (outputStream != null) {
                            IOUtils.closeSafely(outputStream);
                        }
                        throw throwable;
                    }
                    IOUtils.closeSafely(inputStream);
                }
                if (outputStream != null) {
                    IOUtils.closeSafely(outputStream);
                }
            }
            if (-1L != baselineFileLength && baselineFileLength != new File(decompressedBaselineLocation).length()) {
                throw new CorruptBaselineException(targetLocalItem, Messages.getString("BaselineFolderCollection.BaselineLengthDoesNotMatch"));
            }
            if (null != md5Digest && null == decompressedHashValue && !symlink) {
                decompressedHashValue = HashUtils.hashFile(new File(decompressedBaselineLocation), "MD5");
            }
            if (haveBaselineHashValue && null != decompressedHashValue && 16 == decompressedHashValue.length && !Arrays.equals(baselineHashValue, decompressedHashValue)) {
                throw new CorruptBaselineException(targetLocalItem, Messages.getString("BaselineFolderCollection.BaselineHashValueDoesNotMatch"));
            }
            if (!symlink) {
                if (outIsBaselineCompressed.get()) {
                    FileHelpers.rename(decompressedBaselineLocation, targetLocalItem);
                } else {
                    FileCopyHelper.copy(decompressedBaselineLocation, targetLocalItem);
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof CorruptBaselineException && null != baselineLocation) {
                FileHelpers.deleteFileWithoutException(baselineLocation);
            }
            File tempFile = new File(decompressedBaselineLocation);
            if (outIsBaselineCompressed.get() && null != decompressedBaselineLocation && tempFile.exists()) {
                FileHelpers.deleteFileWithoutException(decompressedBaselineLocation);
            }
            throw new VersionControlException(ex);
        }
    }

    public static void deleteBaseline(Workspace workspace, List<BaselineFolder> baselineFolders, byte[] baselineFileGuid) {
        BaselineFolder.checkForValidBaselineFileGUID(baselineFileGuid);
        for (BaselineFolder baselineFolder : baselineFolders) {
            if (null == baselineFolder.path) continue;
            String baselineLocation = baselineFolder.getPathFromGUID(baselineFileGuid);
            new File(baselineLocation + BaselineFolder.getGzipExtension()).delete();
            new File(baselineLocation + BaselineFolder.getRawExtension()).delete();
        }
        String programDataBaselineLocation = BaselineFolder.getPathFromGUID(workspace.getLocalMetadataDirectory(), baselineFileGuid);
        new File(programDataBaselineLocation + BaselineFolder.getGzipExtension()).delete();
        new File(programDataBaselineLocation + BaselineFolder.getRawExtension()).delete();
    }

    public static void updateBaselineLocation(Workspace workspace, List<BaselineFolder> baselineFolders, byte[] baselineFileGuid, String currentLocalItem) {
        Check.notNullOrEmpty(currentLocalItem, "currentLocalItem");
        BaselineFolder.checkForValidBaselineFileGUID(baselineFileGuid);
        String newBaselinePartition = BaselineFolder.getPartitionForPath(currentLocalItem);
        String baselineLocation = BaselineFolderCollection.getBaselineLocation(workspace, baselineFolders, baselineFileGuid);
        if (baselineLocation != null && !LocalPath.equals(BaselineFolder.getPartitionForPath(baselineLocation), newBaselinePartition)) {
            BaselineFolder newBaselineFolder = BaselineFolderCollection.getBaselineFolderForPartition(baselineFolders, newBaselinePartition);
            String newBaselineLocation = newBaselineFolder != null ? newBaselineFolder.getPathFromGUID(baselineFileGuid) : BaselineFolder.getPathFromGUID(workspace.getLocalMetadataDirectory(), baselineFileGuid);
            FileHelpers.renameWithoutException(new File(baselineLocation), new File(LocalPath.combine(newBaselineLocation, LocalPath.getFileExtension(baselineLocation))));
        }
    }

    private static BaselineFolder getBaselineFolderForPartition(List<BaselineFolder> baselineFolders, String partition) {
        for (BaselineFolder baselineFolder : baselineFolders) {
            if (null == baselineFolder.partition || !LocalPath.equals(partition, baselineFolder.partition) || BaselineFolderState.VALID != baselineFolder.state) continue;
            return baselineFolder;
        }
        return null;
    }

    public void processBaselineRequests(Workspace workspace, Iterable<BaselineRequest> requests) {
        AtomicReference<Iterable<BaselineRequest>> outFailedLocalRequests = new AtomicReference<Iterable<BaselineRequest>>();
        try {
            this.processBaselineRequests(workspace, requests, false, outFailedLocalRequests);
        }
        catch (CoreCancelException e) {
            // empty catch block
        }
    }

    public void processBaselineRequests(Workspace workspace, Iterable<BaselineRequest> requests, boolean throwIfCanceled, AtomicReference<Iterable<BaselineRequest>> outFailedLocalRequests) throws CoreCancelException {
        outFailedLocalRequests.set(null);
        BaselineUpdaterAsyncOperation localDiskAsyncOp = new BaselineUpdaterAsyncOperation(this);
        TaskMonitor taskMonitor = TaskMonitorService.getTaskMonitor();
        AccountingCompletionService<WorkerStatus> completionService = new AccountingCompletionService<WorkerStatus>(workspace.getClient().getUploadDownloadWorkerExecutor());
        try {
            for (BaselineRequest request : requests) {
                if (null == request.getSourceLocalItem()) continue;
                if (throwIfCanceled && taskMonitor.isCanceled()) {
                    throw new CoreCancelException();
                }
                completionService.submit(new BaselineUpdaterWorker(taskMonitor, request, localDiskAsyncOp));
            }
        }
        catch (CoreCancelException e) {
            BaselineUpdaterAsyncOperation.waitForCompletions(completionService);
            throw e;
        }
        BaselineUpdaterAsyncOperation.waitForCompletions(completionService);
        this.testForFatalError(localDiskAsyncOp);
        BaselineDownloadAsyncOperation downloadAsyncOp = new BaselineDownloadAsyncOperation();
        VersionControlClient client = workspace.getClient();
        try {
            BaselineDownloadWorker worker;
            for (BaselineRequest request : requests) {
                if (null != request.getSourceLocalItem()) continue;
                if (null != request.getDownloadURL()) {
                    worker = new BaselineDownloadWorker(EventSource.newFromHere(), taskMonitor, client, downloadAsyncOp, request.getDownloadURL(), this, request.getBaselineFileGUID());
                    if (throwIfCanceled && taskMonitor.isCanceled()) {
                        throw new CoreCancelException();
                    }
                    completionService.submit(worker);
                    continue;
                }
                this.deleteBaseline(request.getBaselineFileGUID());
            }
            for (BaselineRequest request : localDiskAsyncOp.getFailedRequests()) {
                if (null == request.getDownloadURL()) continue;
                worker = new BaselineDownloadWorker(EventSource.newFromHere(), taskMonitor, client, downloadAsyncOp, request.getDownloadURL(), this, request.getBaselineFileGUID());
                if (throwIfCanceled && taskMonitor.isCanceled()) {
                    throw new CoreCancelException();
                }
                completionService.submit(worker);
            }
        }
        catch (CoreCancelException e) {
            BaselineDownloadAsyncOperation.waitForCompletions(completionService);
            throw e;
        }
        BaselineDownloadAsyncOperation.waitForCompletions(completionService);
        this.testForFatalError(downloadAsyncOp);
        outFailedLocalRequests.set(localDiskAsyncOp.getFailedRequests());
    }

    private void testForFatalError(AsyncOperation asyncOp) throws VersionControlException {
        Check.notNull(asyncOp, "state");
        Throwable fatalError = asyncOp.getFatalError();
        if (fatalError != null) {
            throw new VersionControlException(Messages.getString("BaselineUpdater.FatalErrorUpdatingBaselineFiles"), fatalError);
        }
    }

    public static FileOutputStream createFile(String filePath) throws IOException {
        AtomicBoolean tempCreated = new AtomicBoolean();
        return BaselineFolderCollection.createFile(new AtomicReference<String>(filePath), false, null, tempCreated);
    }

    public static FileOutputStream createFile(AtomicReference<String> filePath, boolean createTempOnFailure, String tempUniqueString, AtomicBoolean tempCreated) throws IOException {
        Exception createException;
        FileOutputStream localStream;
        block5: {
            Check.notNull(filePath, "filePath");
            localStream = null;
            tempCreated.set(false);
            createException = null;
            if (filePath.get() != null && filePath.get().length() > 0) {
                try {
                    localStream = new FileOutputStream(filePath.get());
                }
                catch (Exception ex) {
                    createException = ex;
                    if (createTempOnFailure) break block5;
                    throw new VersionControlException(ex);
                }
            }
        }
        if (localStream == null && createTempOnFailure) {
            tempCreated.set(true);
            File tempFile = TempStorageService.getInstance().createTempFile();
            localStream = new FileOutputStream(tempFile);
            log.info((Object)MessageFormat.format("Could not create baseline folder collection file {0}, using temporary file {1}", filePath.get(), tempFile), (Throwable)createException);
            filePath.set(tempFile.getAbsolutePath());
        } else {
            Check.notNullOrEmpty(filePath.get(), "filePath.get()");
        }
        return localStream;
    }

    private class TokenReaderWriterLock {
        private final Object lock = new Object();
        private int readerCount;
        private int declaredWriters;
        private boolean hasWriter;
        private int lastReadToken = 0;
        private int lastWriteToken = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int enterReadLock() {
            Object object = this.lock;
            synchronized (object) {
                while (this.hasWriter || this.declaredWriters > 0) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ++this.readerCount;
                return ++this.lastReadToken;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exitReadLock(int token) {
            Check.isTrue(token >= 1 && token <= this.lastReadToken, "token");
            Object object = this.lock;
            synchronized (object) {
                --this.readerCount;
                if (0 == this.readerCount && this.declaredWriters > 0) {
                    this.lock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int enterWriteLock() {
            Object object = this.lock;
            synchronized (object) {
                ++this.declaredWriters;
                while (this.readerCount > 0 || this.hasWriter) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                --this.declaredWriters;
                this.hasWriter = true;
                return --this.lastWriteToken;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exitWriteLock(int token) {
            if (token != this.lastWriteToken) {
                throw new IllegalStateException("token");
            }
            Object object = this.lock;
            synchronized (object) {
                this.hasWriter = false;
                this.lock.notifyAll();
            }
        }
    }
}

