/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.path;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.LocalPathFormatException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ServerPathFormatException;
import com.microsoft.tfs.core.clients.versioncontrol.path.ItemValidationError;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.exceptions.InputValidationException;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ItemPath {
    public static String canonicalize(String localOrServerPath) {
        if (localOrServerPath == null) {
            return null;
        }
        if (localOrServerPath.length() == 0) {
            return localOrServerPath;
        }
        if (ServerPath.isServerPath(localOrServerPath)) {
            try {
                return ServerPath.canonicalize(localOrServerPath);
            }
            catch (ServerPathFormatException e) {
                return localOrServerPath;
            }
        }
        return LocalPath.canonicalize(localOrServerPath);
    }

    public static ItemValidationError checkItem(AtomicReference<String> item, String parameterName, boolean allowNull, boolean allowWildcards, boolean allow8Dot3Paths, boolean checkReservedCharacters) {
        return ItemPath.checkItem(item, parameterName, allowNull, allowWildcards, allow8Dot3Paths, checkReservedCharacters, 259);
    }

    public static ItemValidationError checkItem(AtomicReference<String> item, String parameterName, boolean allowNull, boolean allowWildcards, boolean allow8Dot3Paths, boolean checkReservedCharacters, int maxServerPathLength) {
        if (item != null && ServerPath.isServerPath(item.get())) {
            return ServerPath.checkServerItem(item, parameterName, allowNull, allowWildcards, allow8Dot3Paths, checkReservedCharacters, maxServerPathLength);
        }
        return LocalPath.checkLocalItem(item.get(), parameterName, allowNull, allowWildcards, allow8Dot3Paths, checkReservedCharacters);
    }

    public static String smartNativeToTFS(String localOrServerPath) {
        if (!ServerPath.isServerPath(localOrServerPath)) {
            return LocalPath.nativeToTFS(localOrServerPath);
        }
        return localOrServerPath;
    }

    public static String smartTFSToNative(String localOrServerPath) {
        if (!ServerPath.isServerPath(localOrServerPath)) {
            return LocalPath.tfsToNative(localOrServerPath);
        }
        return localOrServerPath;
    }

    public static boolean isWildcard(String localOrServerPath, int index, int count) {
        return ItemPath.isWildcard(localOrServerPath.substring(index, index + count));
    }

    public static boolean isWildcard(String localOrServerPath) {
        if (localOrServerPath == null || localOrServerPath.length() == 0) {
            return false;
        }
        if (ServerPath.isServerPath(localOrServerPath)) {
            return ServerPath.isWildcard(localOrServerPath);
        }
        return LocalPath.isWildcard(localOrServerPath);
    }

    public static boolean matchesWildcardFile(String fileName, String wildcardPattern) {
        return ItemPath.matchesWildcardFile(fileName, 0, wildcardPattern, 0);
    }

    public static boolean matchesWildcardFile(String fileName, int fileIndex, String wildcardPattern, int wildcardIndex) {
        while (wildcardIndex < wildcardPattern.length()) {
            if (wildcardPattern.charAt(wildcardIndex) == '*') {
                while (++wildcardIndex < wildcardPattern.length() && wildcardPattern.charAt(wildcardIndex) == '*') {
                }
                while (true) {
                    if (ItemPath.matchesWildcardFile(fileName, fileIndex, wildcardPattern, wildcardIndex)) {
                        return true;
                    }
                    if (fileIndex == fileName.length()) {
                        return false;
                    }
                    if (fileName.charAt(fileIndex) == '.' && fileName.lastIndexOf(46, fileName.length() - 1) == fileIndex && wildcardPattern.length() == wildcardIndex + 1 && wildcardPattern.charAt(wildcardIndex) == '.') {
                        return false;
                    }
                    ++fileIndex;
                }
            }
            if (fileIndex == fileName.length()) {
                return wildcardPattern.charAt(wildcardIndex) == '.' && wildcardPattern.lastIndexOf(46, wildcardPattern.length() - 1) == wildcardIndex && ItemPath.matchesWildcardFile(fileName, fileIndex, wildcardPattern, wildcardIndex + 1);
            }
            if (!fileName.regionMatches(true, fileIndex, wildcardPattern, wildcardIndex, 1) && wildcardPattern.charAt(wildcardIndex) != '?') {
                return false;
            }
            ++fileIndex;
            ++wildcardIndex;
        }
        return fileIndex == fileName.length() || fileName.charAt(fileIndex) == '.' && fileIndex + 1 == fileName.length();
    }

    public static void checkForIllegalDollarInPath(String serverOrLocalPath) throws InputValidationException {
        if (serverOrLocalPath == null) {
            return;
        }
        int length = serverOrLocalPath.length();
        for (int i = 1; i < length; ++i) {
            if (serverOrLocalPath.charAt(i) != '$' || !ServerPath.isSeparator(serverOrLocalPath.charAt(i - 1))) continue;
            String message = MessageFormat.format(Messages.getString("ItemPath.InvalidPathDollarSignFormat"), serverOrLocalPath);
            if (ServerPath.isServerPath(serverOrLocalPath)) {
                throw new ServerPathFormatException(message);
            }
            throw new LocalPathFormatException(message);
        }
    }

    public static boolean equals(String serverOrLocalPath1, String serverOrLocalPath2) {
        if (ServerPath.isServerPath(serverOrLocalPath1) && ServerPath.isServerPath(serverOrLocalPath2)) {
            return ServerPath.equals(serverOrLocalPath1, serverOrLocalPath2);
        }
        return LocalPath.equals(serverOrLocalPath1, serverOrLocalPath2);
    }

    public static int hashcode(String serverOrLocalPath) {
        if (ServerPath.isServerPath(serverOrLocalPath)) {
            return ServerPath.hashCode(serverOrLocalPath);
        }
        return LocalPath.hashCode(serverOrLocalPath);
    }
}

