/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.BranchObject;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemIdentifier;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Mapping;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import ms.tfs.versioncontrol.clientservices._03._BranchProperties;
import ms.tfs.versioncontrol.clientservices._03._ItemIdentifier;

public class BranchProperties
extends WebServiceObjectWrapper {
    public BranchProperties(_BranchProperties webServiceObject) {
        super(webServiceObject);
        String displayName = webServiceObject.getOwnerDisplayName();
        if (displayName == null || displayName.length() == 0) {
            this.setOwnerDisplayName(webServiceObject.getOwner());
        }
    }

    public _BranchProperties getWebServiceObject() {
        return (_BranchProperties)this.webServiceObject;
    }

    public Mapping[] getBranchMappings() {
        return (Mapping[])WrapperUtils.wrap(Mapping.class, this.getWebServiceObject().getBranchMappings());
    }

    public String getDescription() {
        return this.getWebServiceObject().getDescription();
    }

    public String getOwner() {
        return this.getWebServiceObject().getOwner();
    }

    public String getOwnerDisplayName() {
        return this.getWebServiceObject().getOwnerDisplayName();
    }

    public ItemIdentifier getParentBranch() {
        if (this.getWebServiceObject().getParentBranch() == null) {
            return null;
        }
        return new ItemIdentifier(this.getWebServiceObject().getParentBranch());
    }

    public ItemIdentifier getRootItem() {
        return new ItemIdentifier(this.getWebServiceObject().getRootItem());
    }

    public void setDescription(String desc) {
        this.getWebServiceObject().setDescription(desc);
    }

    public void setOwner(String owner) {
        this.getWebServiceObject().setOwner(owner);
    }

    public void setOwnerDisplayName(String owner) {
        this.getWebServiceObject().setOwnerDisplayName(owner);
    }

    public static BranchProperties from(ItemIdentifier item, String desc, String owner, String ownerDisplayName, ItemIdentifier parent) {
        Check.notNull(item, "item");
        _ItemIdentifier parentItem = null;
        if (parent != null) {
            parentItem = parent.getWebServiceObject();
        }
        return new BranchProperties(new _BranchProperties(item.getWebServiceObject(), desc, owner, ownerDisplayName, owner, parentItem, null));
    }

    public static BranchProperties from(BranchProperties prop, BranchObject parent) {
        return BranchProperties.from(prop.getRootItem(), prop.getDescription(), prop.getOwner(), prop.getOwnerDisplayName(), parent.getProperties().getRootItem());
    }
}

