/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.webservices;

import com.microsoft.tfs.core.clients.webservices.SecurityIdentifier;
import com.microsoft.tfs.util.GUID;
import java.text.MessageFormat;

public abstract class SIDIdentityHelper {
    private static final long TFS_SUB_AUTHORITY_0 = 1551374245L;
    private static final long TFS_SUB_AUTHORITY_1 = 1204400969L;
    private static final long TFS_SUB_AUTHORITY_2 = 2402986413L;
    private static final long TFS_SUB_AUTHORITY_3 = 2179408616L;
    public static final String TEAM_FOUNDATION_SID_PREFIX = "S-1-9-" + Long.toString(1551374245L);
    public static final String WELL_KNOWN_DOMAIN_SID = MessageFormat.format("{0}-{1}-{2}-{3}", TEAM_FOUNDATION_SID_PREFIX, Long.toString(1204400969L), Long.toString(2402986413L), Long.toString(2179408616L));
    public static final GUID WELL_KNOWN_DOMAIN_ID = new GUID("A517785C-C947-49B3-8F3A-A9AD81E722E8");
    public static final String WELL_KNOWN_SID_TYPE = "-0-";
    public static final String PHANTOM_KNOWN_SID_TYPE = "-2-";
    public static final int PHANTOM_SID_TYPE = 2;
    public static final String WELL_KNOWN_SID_PREFIX = WELL_KNOWN_DOMAIN_SID + "-0-";
    public static final String PHANTOM_SID_PREFIX = WELL_KNOWN_DOMAIN_SID + 2;

    public static SecurityIdentifier getDomainSID(GUID domainId) {
        long[] subAuthorities = new long[5];
        SIDIdentityHelper.fillDomainSID(subAuthorities, domainId);
        return new SecurityIdentifier(9L, subAuthorities);
    }

    private static void fillDomainSID(long[] subAuthorities, GUID domainId) {
        subAuthorities[0] = 1551374245L;
        byte[] binaryGuid = domainId.getGUIDBytes();
        for (int i = 0; i < 4; ++i) {
            subAuthorities[i + 1] = SIDIdentityHelper.guidBytesToLong(binaryGuid, i * 4);
        }
    }

    private static long guidBytesToLong(byte[] array, int index) {
        long ret = 0L;
        ret |= (long)(array[index + 3] & 0xFF);
        ret |= (long)(array[index + 2] & 0xFF) << 8;
        ret |= (long)(array[index + 1] & 0xFF) << 16;
        return ret |= (long)(array[index + 0] & 0xFF) << 24;
    }
}

