/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.category;

import com.microsoft.tfs.core.clients.workitem.category.Category;
import com.microsoft.tfs.core.clients.workitem.category.CategoryCollection;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.category.CategoryImpl;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.dao.WorkItemTypeCategoryMetadata;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CategoryCollectionImpl
implements CategoryCollection {
    private final List<Category> categories;

    public CategoryCollectionImpl(WITContext context, int projectId) {
        WorkItemTypeCategoryMetadata[] categoriesMetadata = context.getMetadata().getWorkItemTypeCategoriesTable().getCategories();
        this.categories = new ArrayList<Category>();
        for (int i = 0; i < categoriesMetadata.length; ++i) {
            WorkItemTypeCategoryMetadata categoryMetadata = categoriesMetadata[i];
            if (categoryMetadata.getProjectID() != projectId) continue;
            this.categories.add(new CategoryImpl(categoryMetadata.getCategoryID(), categoryMetadata.getName(), categoryMetadata.getReferenceName(), categoryMetadata.getDefaultWorkItemTypeID()));
        }
    }

    @Override
    public Iterator<Category> iterator() {
        return this.categories.iterator();
    }

    @Override
    public int size() {
        return this.categories.size();
    }

    @Override
    public Category get(int index) {
        return this.categories.get(index);
    }

    @Override
    public boolean contains(String categoryReferenceName) {
        return this.get(categoryReferenceName) != null;
    }

    @Override
    public Category get(String categoryReferenceName) {
        for (Category category : this.categories) {
            if (!category.getReferenceName().equals(categoryReferenceName)) continue;
            return category;
        }
        return null;
    }
}

