/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.fields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FieldListAssociationSupport {
    private Set allowed;
    private Set prohibited;
    private Set suggested;
    private List pickList;
    private boolean computedPickList = false;

    Set getAllowed() {
        return this.allowed;
    }

    Set getProhibited() {
        return this.prohibited;
    }

    Set getSuggested() {
        return this.suggested;
    }

    public void reset() {
        this.allowed = null;
        this.prohibited = null;
        this.suggested = null;
        this.computedPickList = false;
    }

    public void addProhibitedValues(Collection values) {
        if (this.prohibited == null) {
            this.prohibited = new HashSet();
        }
        this.prohibited.addAll(values);
    }

    public void addAllowedValues(Collection values) {
        if (this.allowed == null) {
            this.allowed = new HashSet();
            this.allowed.addAll(values);
        } else {
            this.allowed.retainAll(values);
        }
    }

    public void addSuggestedValues(Collection values) {
        if (this.suggested == null) {
            this.suggested = new HashSet();
        }
        this.suggested.addAll(values);
    }

    public List getPickList() {
        if (!this.computedPickList) {
            this.computedPickList = true;
            if (this.suggested == null && this.allowed == null) {
                this.pickList = null;
            } else {
                this.pickList = new ArrayList();
                if (this.suggested != null) {
                    this.pickList.addAll(this.suggested);
                    if (this.allowed != null) {
                        this.pickList.retainAll(this.allowed);
                    }
                } else {
                    this.pickList.addAll(this.allowed);
                }
                if (this.prohibited != null) {
                    this.pickList.removeAll(this.prohibited);
                }
                this.pickList.remove(null);
                if (this.pickList.size() == 0) {
                    this.pickList = null;
                } else {
                    Collections.sort(this.pickList);
                }
            }
        }
        return this.pickList;
    }

    public boolean isValidating() {
        return this.allowed != null || this.prohibited != null;
    }

    public boolean isValueLegal(String value) {
        if (this.allowed == null && this.prohibited == null) {
            return true;
        }
        if (this.allowed != null && this.prohibited == null) {
            return this.allowed.contains(value);
        }
        if (this.allowed == null && this.prohibited != null) {
            return !this.prohibited.contains(value);
        }
        return this.allowed.contains(value) && !this.prohibited.contains(value);
    }
}

