/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.fields;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FieldReferenceBasedCache<T> {
    private final Object lock = new Object();
    private final Map<String, T> referenceNames = new HashMap<String, T>();
    private final Map<String, T> referenceNamesCaseSensitive = new HashMap<String, T>();
    private final Map<String, T> displayNames = new HashMap<String, T>();
    private final Map<String, T> displayNamesCaseSensitive = new HashMap<String, T>();
    private final Map<Integer, T> ids = new HashMap<Integer, T>();
    private final Set<T> valueSet = new HashSet<T>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> values() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableSet(this.valueSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.referenceNames.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.referenceNames.clear();
            this.referenceNamesCaseSensitive.clear();
            this.displayNames.clear();
            this.displayNamesCaseSensitive.clear();
            this.ids.clear();
            this.valueSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(T object, String displayName, String referenceName, int id) {
        if (!FieldReferenceBasedCache.isDisplayName(displayName)) {
            throw new IllegalArgumentException(MessageFormat.format("the name [{0}] is not a valid display name ({1},{2},{3})", displayName, displayName, referenceName, Integer.toString(id)));
        }
        if (!FieldReferenceBasedCache.isReferenceName(referenceName)) {
            throw new IllegalArgumentException(MessageFormat.format("the name [{0}] is not a valid reference name ({1},{2},{3})", referenceName, displayName, referenceName, Integer.toString(id)));
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.referenceNames.put(this.createKey(referenceName, false), object);
            this.referenceNamesCaseSensitive.put(this.createKey(referenceName, true), object);
            this.displayNames.put(this.createKey(displayName, false), object);
            this.displayNamesCaseSensitive.put(this.createKey(displayName, true), object);
            this.ids.put(new Integer(id), object);
            this.valueSet.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int id) {
        Integer key = new Integer(id);
        Object object = this.lock;
        synchronized (object) {
            return this.ids.get(key);
        }
    }

    public T get(String fieldName) {
        return this.get(fieldName, true, true, false);
    }

    public T get(String fieldName, boolean matchReferenceName, boolean matchDisplayName, boolean caseSensitive) {
        if (matchReferenceName && matchDisplayName) {
            if (FieldReferenceBasedCache.isReferenceName(fieldName)) {
                return this.getByReferenceName(fieldName, caseSensitive);
            }
            return this.getByDisplayName(fieldName, caseSensitive);
        }
        if (!matchReferenceName && matchDisplayName) {
            if (!FieldReferenceBasedCache.isDisplayName(fieldName)) {
                throw new IllegalArgumentException(MessageFormat.format("the name [{0}] is not a display name", fieldName));
            }
            return this.getByDisplayName(fieldName, caseSensitive);
        }
        if (matchReferenceName && !matchDisplayName) {
            if (!FieldReferenceBasedCache.isReferenceName(fieldName)) {
                throw new IllegalArgumentException(MessageFormat.format("the name [{0}] is not a reference name", fieldName));
            }
            return this.getByReferenceName(fieldName, caseSensitive);
        }
        throw new IllegalArgumentException("matchReferenceName, matchDisplayName, or both must be true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getByReferenceName(String name, boolean caseSensitive) {
        String key = this.createKey(name, caseSensitive);
        Object object = this.lock;
        synchronized (object) {
            Map<String, T> cache = caseSensitive ? this.referenceNamesCaseSensitive : this.referenceNames;
            return cache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T getByDisplayName(String name, boolean caseSensitive) {
        String key = this.createKey(name, caseSensitive);
        Object object = this.lock;
        synchronized (object) {
            Map<String, T> cache = caseSensitive ? this.displayNamesCaseSensitive : this.displayNames;
            return cache.get(key);
        }
    }

    private String createKey(String input, boolean caseSensitive) {
        return caseSensitive ? input : input.toLowerCase();
    }

    public static boolean isReferenceName(String name) {
        if (name == null) {
            return false;
        }
        return name.indexOf(46) != -1;
    }

    public static boolean isDisplayName(String name) {
        if (name == null) {
            return false;
        }
        return name.trim().length() > 0;
    }
}

