/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.metadata.impl;

import com.microsoft.tfs.core.clients.workitem.internal.metadata.ConstantHandler;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.ConstantSet;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.IConstantSet;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.IMetadataChangeListener;
import com.microsoft.tfs.core.clients.workitem.internal.metadata.Metadata;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConstantHandlerImpl
implements ConstantHandler {
    private final Metadata metadata;
    private final Hashtable<String, IConstantSet> cache = new Hashtable();
    private final boolean disableCache = System.getProperty("com.microsoft.tfs.disable-constant-cache") != null;
    private static final Log log = LogFactory.getLog(ConstantHandlerImpl.class);

    public ConstantHandlerImpl(Metadata metadata) {
        this.metadata = metadata;
        metadata.addMetadataChangeListener(new IMetadataChangeListener(){

            @Override
            public void metadataChanged(Set<String> tableNames) {
                ConstantHandlerImpl.this.cache.clear();
            }
        });
    }

    @Override
    public IConstantSet getConstantSet(int rootConstantID, boolean oneLevel, boolean twoPlusLevels, boolean leaf, boolean interior, boolean useCache) {
        int[] rootConstantIDs = new int[]{rootConstantID};
        return this.getConstantSet(rootConstantIDs, oneLevel, twoPlusLevels, leaf, interior, useCache);
    }

    @Override
    public IConstantSet getConstantSet(int[] rootConstantIDs, boolean oneLevel, boolean twoPlusLevels, boolean leaf, boolean interior, boolean useCache) {
        if (!useCache || this.disableCache) {
            return new ConstantSet(this.metadata, rootConstantIDs, oneLevel, twoPlusLevels, leaf, interior);
        }
        String key = this.createCacheKey(rootConstantIDs, oneLevel, twoPlusLevels, leaf, interior);
        if (!this.cache.containsKey(key)) {
            ConstantSet set = new ConstantSet(this.metadata, rootConstantIDs, oneLevel, twoPlusLevels, leaf, interior);
            this.cache.put(key, set);
            log.debug((Object)MessageFormat.format("Cache constant set {0} count={1}, cache size={2}", key, set.getSize(), this.cache.size()));
        }
        return this.cache.get(key);
    }

    private String createCacheKey(int[] ids, boolean oneLevel, boolean twoPlusLevels, boolean leaf, boolean interior) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(ids[i]);
        }
        sb.append(".");
        sb.append(oneLevel);
        sb.append(".");
        sb.append(twoPlusLevels);
        sb.append(".");
        sb.append(leaf);
        sb.append(".");
        sb.append(interior);
        return sb.toString();
    }
}

