/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.rules;

public class MatchPattern {
    private final String pattern;

    public MatchPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern must be non-null");
        }
        if (pattern.length() == 0) {
            throw new IllegalArgumentException("pattern must not be an empty string");
        }
        this.pattern = pattern;
    }

    public boolean matches(String input) {
        if (input == null) {
            return false;
        }
        if (input.length() != this.pattern.length()) {
            return false;
        }
        for (int ix = 0; ix < input.length(); ++ix) {
            char inputChar = input.charAt(ix);
            char patternChar = this.pattern.charAt(ix);
            boolean charsMatch = false;
            switch (patternChar) {
                case 'A': 
                case 'a': {
                    charsMatch = Character.isLetter(inputChar);
                    break;
                }
                case 'N': 
                case 'n': {
                    charsMatch = Character.isDigit(inputChar);
                    break;
                }
                case 'X': 
                case 'x': {
                    charsMatch = Character.isLetterOrDigit(inputChar);
                    break;
                }
                default: {
                    boolean bl = charsMatch = Character.toLowerCase(inputChar) == Character.toLowerCase(patternChar);
                }
            }
            if (charsMatch) continue;
            return false;
        }
        return true;
    }
}

