/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.update;

import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.queryhierarchy.QueryItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.update.BaseUpdatePackage;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryDefinition;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryItem;
import com.microsoft.tfs.core.ws.runtime.types.DOMAnyContentType;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.util.Date;
import org.w3c.dom.Element;

public class InsertQueryItemUpdatePackage
extends BaseUpdatePackage {
    private final QueryItem queryItem;

    public InsertQueryItemUpdatePackage(QueryItem queryItem, WITContext context) {
        super(context);
        this.queryItem = queryItem;
        InsertQueryItemUpdatePackage.populate(this.getRoot(), queryItem);
    }

    static final Element populate(Element parent, QueryItem queryItem) {
        Element queryElement = DOMUtils.appendChild(parent, "InsertQueryItem");
        queryElement.setAttribute("QueryID", queryItem.getID().getGUIDString(GUID.GUIDStringFormat.NONE));
        queryElement.setAttribute("QueryParentID", queryItem.getParent().getID().getGUIDString(GUID.GUIDStringFormat.NONE));
        DOMUtils.appendChildWithText(queryElement, "Name", queryItem.getName());
        if (queryItem.getOwnerDescriptor() != null) {
            DOMUtils.appendChildWithText(queryElement, "OwnerIdentifier", queryItem.getOwnerDescriptor().getIdentifier());
            DOMUtils.appendChildWithText(queryElement, "OwnerType", queryItem.getOwnerDescriptor().getIdentityType());
        }
        if (queryItem instanceof QueryDefinition) {
            DOMUtils.appendChildWithText(queryElement, "QueryText", ((QueryDefinition)queryItem).getQueryText());
        }
        return queryElement;
    }

    @Override
    protected void handleUpdateResponse(DOMAnyContentType response) {
        Element responseElement = (Element)response.getElements()[0].getElementsByTagName("InsertQueryItem").item(0);
        Date updateTime = this.parseDate(responseElement.getAttribute("UpdateTime"));
        if (this.queryItem instanceof QueryItemImpl) {
            ((QueryItemImpl)this.queryItem).updateAfterUpdate(updateTime);
        }
    }
}

