/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DataType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Direction;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.IExternal;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeItem;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeTableName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxError;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Tools;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeFieldName
extends NodeItem {
    private final Log log = LogFactory.getLog(NodeFieldName.class);
    private Object tag;
    private DataType dataType;
    private Direction direction;
    private String prefix;

    public NodeFieldName(NodeName n) {
        this(n.getValue());
        this.setStartOffset(n.getStartOffset());
        this.setEndOffset(n.getEndOffset());
    }

    public NodeFieldName(String s) {
        super(NodeType.FIELD_NAME, s);
    }

    public NodeFieldName(NodeName prefix, NodeName n) {
        this(n.getValue());
        this.prefix = prefix.getValue();
        this.setStartOffset(n.getStartOffset());
        this.setEndOffset(n.getEndOffset());
        if (prefix.getStartOffset() >= 0 && prefix.getStartOffset() < this.getStartOffset()) {
            this.setStartOffset(prefix.getStartOffset());
        }
    }

    public NodeFieldName(String prefix, String s) {
        this(s);
        this.prefix = prefix;
    }

    @Override
    public void appendTo(StringBuffer b) {
        if (this.prefix != null && !this.prefix.equals("")) {
            Tools.AppendName(b, this.prefix);
            b.append(".");
        }
        Tools.AppendName(b, this.getValue());
        if (this.direction == Direction.ASCENDING) {
            b.append(" asc");
        }
        if (this.direction == Direction.DESCENDING) {
            b.append(" desc");
        }
    }

    @Override
    public void bind(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        if (e != null) {
            int index;
            String name = this.getValue();
            Object tableTag = tableContext != null ? tableContext.getTag() : null;
            this.tag = e.findField(name, this.prefix, tableTag);
            if (this.tag == null && this.prefix == null && tableTag != null && (index = name.indexOf(46)) > 0 && index + 1 < name.length()) {
                String prefix = name.substring(0, index);
                String str3 = name.substring(index + 1);
                this.tag = e.findField(str3, prefix, tableTag);
                if (this.tag != null) {
                    this.prefix = prefix;
                    this.setValue(str3);
                }
            }
            Tools.ensureSyntax(this.tag != null, SyntaxError.FIELD_DOES_NOT_EXIST_IN_THE_TABLE, this);
            this.dataType = e.getFieldDataType(this.tag);
            Tools.ensureSyntax(this.dataType != DataType.UNKNOWN, SyntaxError.UNKNOWN_FIELD_TYPE, this);
        }
        super.bind(e, tableContext, fieldContext);
    }

    @Override
    public String checkPrefix(String prefix) {
        String currentPrefix = this.prefix == null || this.prefix.length() == 0 ? "" : this.prefix;
        if (prefix == null) {
            prefix = currentPrefix;
        } else {
            if (!prefix.equalsIgnoreCase(currentPrefix)) {
                this.log.debug((Object)"Not equal prefixes");
            }
            Tools.ensureSyntax(prefix.equalsIgnoreCase(currentPrefix), SyntaxError.MIXED_PREFIXES, this);
        }
        return prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    @Override
    public boolean isConst() {
        return false;
    }

    public Object getTag() {
        return this.tag;
    }
}

