/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.pendingcheckin;

import com.microsoft.tfs.core.checkinpolicies.PolicyEvaluator;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNote;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.WorkItemCheckinInfo;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.pendingcheckin.AffectedTeamProjects;
import com.microsoft.tfs.core.pendingcheckin.PendingCheckin;
import com.microsoft.tfs.core.pendingcheckin.PendingCheckinNotes;
import com.microsoft.tfs.core.pendingcheckin.PendingCheckinPendingChanges;
import com.microsoft.tfs.core.pendingcheckin.PendingCheckinPolicies;
import com.microsoft.tfs.core.pendingcheckin.PendingCheckinWorkItems;
import com.microsoft.tfs.core.pendingcheckin.StandardPendingCheckinNotes;
import com.microsoft.tfs.core.pendingcheckin.StandardPendingCheckinPendingChanges;
import com.microsoft.tfs.core.pendingcheckin.StandardPendingCheckinPolicies;
import com.microsoft.tfs.core.pendingcheckin.StandardPendingCheckinWorkItems;
import com.microsoft.tfs.util.Check;

public class StandardPendingCheckin
implements PendingCheckin {
    private final PendingCheckinNotes notes;
    private final PendingCheckinPolicies policies;
    private final PendingCheckinPendingChanges pendingChanges;
    private final PendingCheckinWorkItems workItems;

    public StandardPendingCheckin(Workspace workspace, PendingChange[] allChanges, PendingChange[] checkedChanges, String comment, CheckinNote checkinNotes, WorkItemCheckinInfo[] checkedWorkItems, PolicyEvaluator evaluator) {
        Check.notNull(workspace, "workspace");
        Check.notNull(allChanges, "allChanges");
        Check.notNull(checkedChanges, "checkedChanges");
        Check.notNull(comment, "comment");
        Check.notNull(checkinNotes, "checkinNotes");
        Check.notNull(checkedWorkItems, "checkedWorkItems");
        AffectedTeamProjects affectedTeamProjects = new AffectedTeamProjects(checkedChanges);
        this.notes = new StandardPendingCheckinNotes(checkinNotes, workspace.getClient(), affectedTeamProjects);
        this.pendingChanges = new StandardPendingCheckinPendingChanges(workspace, allChanges, checkedChanges, affectedTeamProjects, comment);
        this.workItems = new StandardPendingCheckinWorkItems(checkedWorkItems);
        this.policies = new StandardPendingCheckinPolicies(this, workspace.getClient(), evaluator);
    }

    @Override
    public PendingCheckinNotes getCheckinNotes() {
        return this.notes;
    }

    @Override
    public PendingCheckinPolicies getCheckinPolicies() {
        return this.policies;
    }

    @Override
    public PendingCheckinPendingChanges getPendingChanges() {
        return this.pendingChanges;
    }

    @Override
    public PendingCheckinWorkItems getWorkItems() {
        return this.workItems;
    }
}

