/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.httpclient.URI;
import com.microsoft.tfs.core.httpclient.URIException;
import com.microsoft.tfs.core.httpclient.util.URIUtil;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.LocaleUtil;
import com.microsoft.tfs.util.StringUtil;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URIUtils {
    private static final Log log = LogFactory.getLog(URIUtils.class);
    static final BitSet ALLOWED_QUERY_CHARS_WITH_PERCENT = (BitSet)URI.allowed_query.clone();
    static final BitSet ALLOWED_PATH_CHARS_WITH_PERCENT;
    public static final String VSTS_ROOT_URL_STRING = "https://app.vssps.visualstudio.com";
    public static final String VSTS_ROOT_SIGNIN_URL_STRING = "https://app.vssps.visualstudio.com/_signin";
    public static final String VSTS_ROOT_SIGNOUT_URL_STRING = "https://app.vssps.visualstudio.com/_signout";
    public static final String VSTS_SUFFIX = ".visualstudio.com";
    public static final String TFS_REALM_URL_STRING = "https://tfs.app.visualstudio.com";
    public static final java.net.URI VSTS_ROOT_URL;
    public static final java.net.URI VSTS_ROOT_SIGNIN_URL;
    public static final java.net.URI VSTS_ROOT_SIGNOUT_URL;

    public static java.net.URI ensurePathHasTrailingSlash(java.net.URI uri) {
        Check.notNull(uri, "uri");
        if (uri.isOpaque()) {
            return uri;
        }
        String path = uri.getPath();
        if (path != null && path.endsWith("/")) {
            return uri;
        }
        path = path == null ? "/" : path + "/";
        return URIUtils.newURI(uri.getScheme(), uri.getAuthority(), path, uri.getQuery(), uri.getFragment());
    }

    public static java.net.URI toLowerCase(java.net.URI uri) {
        Check.notNull(uri, "uri");
        if (uri.isOpaque()) {
            return uri;
        }
        String scheme = uri.getScheme() != null ? uri.getScheme().toLowerCase(LocaleUtil.ROOT) : null;
        String authority = uri.getAuthority() != null ? uri.getAuthority().toLowerCase(LocaleUtil.ROOT) : null;
        String path = uri.getPath() != null ? uri.getPath().toLowerCase(LocaleUtil.ROOT) : null;
        String query = uri.getQuery() != null ? uri.getQuery().toLowerCase(LocaleUtil.ROOT) : null;
        String fragment = uri.getFragment() != null ? uri.getFragment().toLowerCase(LocaleUtil.ROOT) : null;
        return URIUtils.newURI(scheme, authority, path, query, fragment);
    }

    public static java.net.URI removeTrailingSlash(java.net.URI uri) {
        Check.notNull(uri, "uri");
        if (uri.isOpaque()) {
            return uri;
        }
        String path = uri.getPath();
        if (path == null) {
            path = "/";
        } else if (!path.equals("/")) {
            while (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return URIUtils.newURI(uri.getScheme(), uri.getAuthority(), path, uri.getQuery(), uri.getFragment());
    }

    public static java.net.URI removeQueryParts(java.net.URI uri) {
        Check.notNull(uri, "uri");
        try {
            return new java.net.URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            IllegalArgumentException e2 = new IllegalArgumentException(MessageFormat.format(Messages.getString("URIUtils.IllegalURIFormat"), uri));
            e2.initCause(e);
            throw e2;
        }
    }

    public static java.net.URI removePathAndQueryParts(java.net.URI uri) {
        Check.notNull(uri, "uri");
        try {
            return new java.net.URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            IllegalArgumentException e2 = new IllegalArgumentException(MessageFormat.format(Messages.getString("URIUtils.IllegalURIFormat"), uri));
            e2.initCause(e);
            throw e2;
        }
    }

    public static java.net.URI newURI(String uri) {
        Check.notNull(uri, "uri");
        try {
            return new java.net.URI(uri);
        }
        catch (URISyntaxException e) {
            URI encodedUri;
            try {
                encodedUri = new URI(uri, false);
            }
            catch (URIException e2) {
                IllegalArgumentException e22 = new IllegalArgumentException(MessageFormat.format(Messages.getString("URIUtils.IllegalURIFormat"), uri));
                e22.initCause(e2);
                throw e22;
            }
            try {
                return new java.net.URI(encodedUri.getEscapedURIReference());
            }
            catch (URISyntaxException e3) {
                IllegalArgumentException e2 = new IllegalArgumentException(MessageFormat.format(Messages.getString("URIUtils.IllegalURIFormat"), uri));
                e2.initCause(e3);
                throw e2;
            }
        }
    }

    public static java.net.URI newURI(String scheme, String authority, String path, String query, String fragment) {
        StringBuffer sb = new StringBuffer();
        try {
            if (scheme != null) {
                sb.append(scheme);
                sb.append(':');
            }
            if (authority != null) {
                sb.append("//");
                sb.append(URIUtil.encode(authority, URI.allowed_authority));
            }
            if (path != null) {
                sb.append(URIUtil.encodePath(path));
            }
            if (query != null) {
                sb.append('?');
                sb.append(URIUtil.encodeQuery(query));
            }
            if (fragment != null) {
                sb.append('#');
                sb.append(URIUtil.encode(fragment, URI.allowed_fragment));
            }
        }
        catch (URIException e) {
            IllegalArgumentException e2 = new IllegalArgumentException(MessageFormat.format(Messages.getString("URIUtils.IllegalURIPartsFormat"), scheme, authority, path, query, fragment));
            e2.initCause(e);
            throw e2;
        }
        return java.net.URI.create(sb.toString());
    }

    public static java.net.URI newURI(String scheme, String authority, String path, String query) {
        return URIUtils.newURI(scheme, authority, path, query, null);
    }

    public static java.net.URI newURI(String scheme, String authority, String path) {
        return URIUtils.newURI(scheme, authority, path, null, null);
    }

    public static java.net.URI newURI(String scheme, String authority) {
        return URIUtils.newURI(scheme, authority, null, null, null);
    }

    public static java.net.URI addQueryParameters(java.net.URI parent, Map<String, String> queryParameters) {
        if (queryParameters == null || queryParameters.size() == 0) {
            return parent;
        }
        StringBuilder sb = new StringBuilder(URIUtils.removeQueryParts(parent).toASCIIString());
        boolean isFirstParameter = true;
        for (Map.Entry<String, String> queryParameter : queryParameters.entrySet()) {
            if (isFirstParameter) {
                sb.append("?");
                isFirstParameter = false;
            } else {
                sb.append("&");
            }
            try {
                sb.append(URIUtil.encodeWithinQuery(queryParameter.getKey()));
                sb.append("=");
                sb.append(URIUtil.encodeWithinQuery(queryParameter.getValue()));
            }
            catch (URIException e) {
                IllegalArgumentException e2 = new IllegalArgumentException(MessageFormat.format(Messages.getString("URIUtils.IllegalQueryParameterFormat"), queryParameter.getKey(), queryParameter.getValue()));
                e2.initCause(e);
                throw e2;
            }
        }
        return URIUtils.newURI(sb.toString());
    }

    public static java.net.URI resolve(java.net.URI parent, java.net.URI child) {
        Check.notNull(parent, "parent");
        Check.notNull(child, "child");
        if (!child.isAbsolute() && !parent.isOpaque()) {
            parent = URIUtils.ensurePathHasTrailingSlash(parent);
        }
        return parent.resolve(child);
    }

    public static java.net.URI resolve(String parent, String child) {
        Check.notNull(parent, "parent");
        Check.notNull(child, "child");
        java.net.URI parentUri = URIUtils.newURI(parent);
        java.net.URI childUri = URIUtils.newURI(child);
        return URIUtils.resolve(parentUri, childUri);
    }

    public static java.net.URI resolve(java.net.URI parent, String child) {
        Check.notNull(parent, "parent");
        Check.notNull(child, "child");
        java.net.URI childUri = URIUtils.newURI(child);
        return URIUtils.resolve(parent, childUri);
    }

    public static String safeGetHost(java.net.URI uri) {
        Check.notNull(uri, "uri");
        String host = uri.getHost();
        if (host == null) {
            try {
                host = uri.toURL().getHost();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return host;
    }

    public static String combinePaths(String path1, String path2) {
        return URIUtils.combinePaths(path1, path2, false);
    }

    public static String combinePaths(String path1, String path2, boolean encodeRelativePath) {
        if (encodeRelativePath && path2 != null) {
            try {
                path2 = URIUtil.encodePath(path2);
            }
            catch (URIException e) {
                IllegalArgumentException e2 = new IllegalArgumentException(MessageFormat.format(Messages.getString("URIUtils.IllegalURIPathFormat"), path2));
                e2.initCause(e);
                throw e2;
            }
        }
        if (path1 == null || path1.length() == 0) {
            return path2;
        }
        if (path2 == null || path2.length() == 0) {
            return path1;
        }
        char separator = path1.indexOf("/") >= 0 ? (char)'/' : '\\';
        char[] trimChars = new char[]{'\\', '/'};
        return StringUtil.trimEnd(path1, trimChars) + separator + StringUtil.trimBegin(path2, trimChars);
    }

    public static String combinePartiallyEncodedPaths(String path1, String path2) {
        if (path2 != null) {
            try {
                path2 = URIUtil.encode(path2, ALLOWED_PATH_CHARS_WITH_PERCENT);
            }
            catch (URIException e) {
                IllegalArgumentException e2 = new IllegalArgumentException(MessageFormat.format(Messages.getString("URIUtils.IllegalURIPathFormat"), path2));
                e2.initCause(e);
                throw e2;
            }
        }
        return URIUtils.combinePaths(path1, path2);
    }

    public static String encodeQueryIgnoringPercentCharacters(String partiallyEncoded) {
        Check.notNull(partiallyEncoded, "partiallyEncoded");
        try {
            return URIUtil.encode(partiallyEncoded, ALLOWED_QUERY_CHARS_WITH_PERCENT);
        }
        catch (URIException e) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("URIUtils.IllegalURIQueryStringFormat"), partiallyEncoded));
        }
    }

    public static String decodeForDisplay(java.net.URI uri) {
        Check.notNull(uri, "uri");
        try {
            return URIUtil.decode(uri.toASCIIString());
        }
        catch (URIException e) {
            log.warn((Object)MessageFormat.format("Couldn''t decode URI [{0}] display string, returning raw instead", uri.toASCIIString()), (Throwable)e);
            return uri.toString();
        }
    }

    public static String decodeForDisplay(String asciiURIString) {
        Check.notNull(asciiURIString, "asciiURIString");
        try {
            return URIUtil.decode(asciiURIString);
        }
        catch (URIException e) {
            log.warn((Object)MessageFormat.format("Couldn''t decode URI [{0}] display string, returning raw instead", asciiURIString), (Throwable)e);
            return asciiURIString;
        }
    }

    static {
        ALLOWED_QUERY_CHARS_WITH_PERCENT.set(37);
        ALLOWED_PATH_CHARS_WITH_PERCENT = (BitSet)URI.allowed_abs_path.clone();
        ALLOWED_PATH_CHARS_WITH_PERCENT.set(37);
        VSTS_ROOT_URL = URIUtils.newURI(VSTS_ROOT_URL_STRING);
        VSTS_ROOT_SIGNIN_URL = URIUtils.newURI(VSTS_ROOT_SIGNIN_URL_STRING);
        VSTS_ROOT_SIGNOUT_URL = URIUtils.newURI(VSTS_ROOT_SIGNOUT_URL_STRING);
    }
}

