/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util.notifications;

import com.microsoft.tfs.core.util.notifications.Notification;
import com.microsoft.tfs.core.util.notifications.NotificationListener;
import com.microsoft.tfs.core.util.notifications.NotificationManager;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.listeners.ListenerRunnable;
import com.microsoft.tfs.util.listeners.SingleListenerFacade;

abstract class AbstractNotificationManager
implements NotificationManager {
    private final SingleListenerFacade listeners = new SingleListenerFacade(NotificationListener.class);

    @Override
    public void addListener(NotificationListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void removeListener(NotificationListener listener) {
        this.listeners.removeListener(listener);
    }

    protected void clearListeners() {
        this.listeners.getListenerList().clear();
    }

    protected void fireNotificationReceived(final Notification notification, final long param1, final long param2) {
        Check.notNull(notification, "notification");
        this.listeners.getListenerList().foreachListener(new ListenerRunnable(){

            @Override
            public boolean run(Object listener) throws Exception {
                ((NotificationListener)listener).notificationReceived(notification, param1, param2);
                return true;
            }
        });
    }
}

