/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util.notifications;

import com.microsoft.tfs.core.util.notifications.AbstractNotificationManager;
import com.microsoft.tfs.core.util.notifications.Notification;
import com.microsoft.tfs.core.util.notifications.QueuedNotification;
import com.microsoft.tfs.jni.MessageWindow;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Platform;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageWindowNotificationManager
extends AbstractNotificationManager {
    private static final Log log = LogFactory.getLog(MessageWindowNotificationManager.class);
    private static final long SEND_DELAY_MS = 5000L;
    private static final long SEND_PERIOD_MS = 5000L;
    private static final String MESSAGE_WINDOW_CLASS_NAME = "TeamFoundationNotificationWindow";
    private static final String MESSAGE_WINDOW_TITLE = "TEE TeamFoundationNotificationWindow";
    private static final long[] MESSAGE_WINDOW_USER_DATA_TARGETS = new long[]{5L, 3L};
    private final MessageWindow messageWindow;
    private final LinkedList<QueuedNotification> sendQueue = new LinkedList();
    private final Timer timer = new Timer(false);

    public MessageWindowNotificationManager() {
        if (Platform.isCurrentPlatform(Platform.WINDOWS)) {
            this.messageWindow = new MessageWindow(0L, MESSAGE_WINDOW_CLASS_NAME, MESSAGE_WINDOW_TITLE, 5L, new MessageWindow.MessageListener(){

                @Override
                public void messageReceived(int msg, long wParam, long lParam) {
                    Notification n = Notification.fromValue(msg);
                    if (n == null) {
                        log.info((Object)MessageFormat.format("Ignoring unknown notification msg={0}, wParam={1}, lParam={2}", Integer.toString(msg), Long.toHexString(wParam), Long.toHexString(lParam)));
                    } else {
                        MessageWindowNotificationManager.this.fireNotificationReceived(n, wParam, lParam);
                    }
                }
            });
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    MessageWindowNotificationManager.this.sendQueuedNotifications();
                }
            }, 5000L, 5000L);
        } else {
            this.messageWindow = null;
        }
    }

    @Override
    public void close() {
        this.timer.cancel();
        this.clearListeners();
        this.sendQueuedNotifications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendNotification(Notification notification, int param1, int param2) {
        Check.notNull(notification, "notification");
        LinkedList<QueuedNotification> linkedList = this.sendQueue;
        synchronized (linkedList) {
            for (QueuedNotification ni : this.sendQueue) {
                if (!notification.equals(ni)) continue;
                return;
            }
            this.sendQueue.add(new QueuedNotification(notification, param1, param2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQueuedNotifications() {
        QueuedNotification[] notifications = null;
        LinkedList<QueuedNotification> linkedList = this.sendQueue;
        synchronized (linkedList) {
            notifications = this.sendQueue.toArray(new QueuedNotification[this.sendQueue.size()]);
            this.sendQueue.clear();
        }
        if (notifications.length == 0) {
            return;
        }
        for (QueuedNotification ni : notifications) {
            if (!Platform.isCurrentPlatform(Platform.WINDOWS)) continue;
            this.messageWindow.sendMessage(MESSAGE_WINDOW_CLASS_NAME, MESSAGE_WINDOW_USER_DATA_TARGETS, ni.notification.getValue(), ni.param1, ni.param2);
        }
    }
}

