/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.stax;

import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public abstract class StaxUtils {
    public static String getElementTextOrNull(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", reader.getLocation());
        }
        int eventType = reader.next();
        StringBuffer content = null;
        while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                if (content == null) {
                    content = new StringBuffer();
                }
                content.append(reader.getText());
            } else if (eventType != 3 && eventType != 5) {
                if (eventType == 8) {
                    throw new XMLStreamException("unexpected end of document when reading element text content", reader.getLocation());
                }
                if (eventType == 1) {
                    throw new XMLStreamException("element text content may not contain START_ELEMENT", reader.getLocation());
                }
                if (eventType != 10) {
                    String messageFormat = "Unexpected event type {0}";
                    String message = MessageFormat.format("Unexpected event type {0}", eventType);
                    throw new XMLStreamException(message, reader.getLocation());
                }
            }
            eventType = reader.next();
        }
        return content == null ? null : content.toString();
    }

    public static void copyCurrentElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        Check.notNull(reader, "reader");
        Check.notNull(writer, "writer");
        int event = reader.getEventType();
        Check.isTrue(event == 1, "event == XMLStreamConstants.START_ELEMENT");
        int elementDepth = 0;
        while (true) {
            switch (event) {
                case 1: {
                    String elementPrefix = reader.getPrefix();
                    String elementLocalName = reader.getLocalName();
                    String elementNameSpace = reader.getNamespaceURI();
                    writer.writeStartElement(elementPrefix != null ? elementPrefix : "", elementLocalName != null ? elementLocalName : "", elementNameSpace != null ? elementNameSpace : "");
                    int n = reader.getAttributeCount();
                    for (int i = 0; i < n; ++i) {
                        String prefix = reader.getAttributePrefix(i);
                        String nameSpace = reader.getAttributeNamespace(i);
                        String localName = reader.getAttributeLocalName(i);
                        String value = reader.getAttributeValue(i);
                        writer.writeAttribute(prefix != null ? prefix : "", nameSpace != null ? nameSpace : "", localName != null ? localName : "", value != null ? value : "");
                    }
                    ++elementDepth;
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                    if (--elementDepth >= 1) break;
                    return;
                }
                case 3: {
                    writer.writeProcessingInstruction(reader.getPITarget(), reader.getPIData());
                    break;
                }
                case 4: {
                    writer.writeCharacters(reader.getText());
                    break;
                }
                case 5: {
                    writer.writeComment(reader.getText());
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    throw new RuntimeException("XMLStreamConstants.START_DOCUMENT shouldn't happen in element copy");
                }
                case 8: {
                    throw new RuntimeException("XMLStreamConstants.END_DOCUMENT shouldn't happen in element copy");
                }
                case 9: {
                    writer.writeEntityRef(reader.getLocalName());
                    break;
                }
                case 10: {
                    throw new RuntimeException("XMLStreamConstants.ATTRIBUTE shouldn't happen in element copy");
                }
                case 11: {
                    writer.writeDTD(reader.getText());
                    break;
                }
                case 12: {
                    writer.writeCData(reader.getText());
                    break;
                }
                case 13: {
                    writer.writeNamespace(reader.getNamespacePrefix(0), reader.getNamespaceURI(0));
                    break;
                }
                case 14: {
                    throw new RuntimeException("Can't handle XMLStreamConstants.NOTATION_DECLARATION");
                }
                case 15: {
                    throw new RuntimeException("Can't handle XMLStreamConstants.ENTITY_DECLARATION");
                }
                default: {
                    String messageFormat = "Unhandled XMLStreamReader event {0}";
                    String message = MessageFormat.format("Unhandled XMLStreamReader event {0}", reader.getEventType());
                    throw new RuntimeException(message);
                }
            }
            event = reader.next();
        }
    }
}

