/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.TypesafeEnum;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeychainEnum
extends TypesafeEnum {
    private static final Log log = LogFactory.getLog(KeychainEnum.class);

    protected KeychainEnum(int value) {
        super(value);
    }

    protected static int computeValue(String fourCharCode) {
        Check.notNull(fourCharCode, "fourCharCode");
        Check.isTrue(fourCharCode.length() == 4, "fourCharCode.length == 4");
        byte[] charValues = new byte[]{0, 0, 0, 0};
        try {
            charValues = fourCharCode.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)MessageFormat.format("Could not get ascii representation of FourCharCode: {0}", fourCharCode), (Throwable)e);
        }
        return charValues[0] << 24 | charValues[1] << 16 | charValues[2] << 8 | charValues[3];
    }
}

