/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni;

import com.microsoft.tfs.jni.ValueType;
import com.microsoft.tfs.util.Check;

public class RegistryValue {
    private final String name;
    private final Object value;
    private final ValueType type;

    public RegistryValue(String name, String value) {
        this.name = name;
        this.value = value;
        this.type = ValueType.REG_SZ;
    }

    public RegistryValue(String name, int value) {
        this.name = name;
        this.value = new Integer(value);
        this.type = ValueType.REG_DWORD;
    }

    public String getName() {
        return this.name;
    }

    public ValueType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isStringType() {
        return this.value instanceof String;
    }

    public boolean isIntegerType() {
        return this.value instanceof Integer;
    }

    public String getStringValue() {
        Check.isTrue(this.isStringType(), "value must be a string type");
        return (String)this.value;
    }

    public int getIntegerValue() {
        Check.isTrue(this.isIntegerType(), "value must be an integer type");
        return (Integer)this.value;
    }
}

