/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util;

import com.microsoft.tfs.util.GUID;

public class CLRHashUtil {
    public static int getGUIDHash(GUID guid) {
        byte[] bytes = guid.getGUIDBytes();
        int _a = (bytes[3] & 0xFF) << 24 | (bytes[2] & 0xFF) << 16 | (bytes[1] & 0xFF) << 8 | bytes[0] & 0xFF;
        short _b = (short)((bytes[5] & 0xFF) << 8 | bytes[4] & 0xFF);
        short _c = (short)((bytes[7] & 0xFF) << 8 | bytes[6] & 0xFF);
        byte _f = bytes[10];
        byte _k = bytes[15];
        return _a ^ ((_b & 0xFFFF) << 16 | _c & 0xFFFF) ^ ((_f & 0xFF) << 24 | _k & 0xFF);
    }

    public static int getStringHashOrcas32(String str) {
        int hash1;
        int hash2 = hash1 = 0x15051505;
        int cpIndex = 0;
        for (int len = str.length(); len > 0; len -= 4) {
            int cp1 = str.codePointAt(cpIndex);
            int cp2 = len >= 2 ? str.codePointAt(cpIndex + 1) : 0;
            int word = (cp2 << 16) + cp1;
            hash1 = (hash1 << 5) + hash1 + (hash1 >> 27) ^ word;
            cpIndex += 2;
            if (len <= 2) break;
            cp1 = str.codePointAt(cpIndex);
            cp2 = len >= 4 ? str.codePointAt(cpIndex + 1) : 0;
            word = (cp2 << 16) + cp1;
            hash2 = (hash2 << 5) + hash2 + (hash2 >> 27) ^ word;
            cpIndex += 2;
        }
        return hash1 + hash2 * 1566083941;
    }

    public static int getStringHashOrcas64(String str) {
        int hash1;
        int hash2 = hash1 = 5381;
        int cpIndex = 0;
        for (int len = str.length(); len > 0; len -= 2) {
            int cp1 = str.codePointAt(cpIndex);
            hash1 = (hash1 << 5) + hash1 ^ cp1;
            ++cpIndex;
            if (len <= 1) break;
            cp1 = str.codePointAt(cpIndex);
            hash2 = (hash2 << 5) + hash2 ^ cp1;
            ++cpIndex;
        }
        return hash1 + hash2 * 1566083941;
    }
}

