/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.logging;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.core.logging.LogEventCollector;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.concurrent.TaskWrappingExecutorService;

@Plugin(name="TeamscaleLog", category="Core", elementType="appender", printObject=true)
public class TeamscaleLogAppender
extends AbstractAppender {
    private static final String TEAMSCALE_LOG_APPENDER_NAME = "TeamscaleLogAppender";
    private static final InheritableThreadLocal<LogEventCollector> LOG_EVENT_HANDLER = new InheritableThreadLocal<LogEventCollector>(){

        @Override
        protected LogEventCollector initialValue() {
            return new LogEventCollector();
        }
    };

    private TeamscaleLogAppender(String name, Filter filter, Layout<?> layout, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
    }

    @PluginFactory
    public static TeamscaleLogAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filters") Filter filter, @PluginElement(value="Layout") Layout<?> layout, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions) {
        Objects.requireNonNull(name, "name");
        layout = Objects.requireNonNullElseGet(layout, PatternLayout::createDefaultLayout);
        return new TeamscaleLogAppender(name, filter, layout, ignoreExceptions);
    }

    public void append(LogEvent event) {
        ((LogEventCollector)LOG_EVENT_HANDLER.get()).addEvent(event);
    }

    public static UnmodifiableList<LogEvent> getLogEvents() {
        return ((LogEventCollector)LOG_EVENT_HANDLER.get()).getLogEvents();
    }

    public static UnmodifiableList<LogEvent> getLogEvents(ELogLevel ... levels) {
        Set<Level> logLevels = Arrays.stream(levels).map(ELogLevel::getLog4JLevel).collect(Collectors.toSet());
        return ((LogEventCollector)LOG_EVENT_HANDLER.get()).getLogEvents(logLevels);
    }

    public static UnmodifiableList<LogEvent> getErrorsAndWarnings() {
        return TeamscaleLogAppender.getLogEvents(ELogLevel.WARN, ELogLevel.ERROR, ELogLevel.FATAL);
    }

    public static UnmodifiableList<LogEvent> getErrors() {
        return TeamscaleLogAppender.getLogEvents(ELogLevel.ERROR, ELogLevel.FATAL);
    }

    public static UnmodifiableList<LoggingEventTransport> getLogEventTransports() {
        return CollectionUtils.asUnmodifiable(LoggingEventTransport.convertFromLog4j(((LogEventCollector)LOG_EVENT_HANDLER.get()).getLogEvents()));
    }

    private static void clearOldLogEvents() {
        LOG_EVENT_HANDLER.set(new LogEventCollector());
    }

    public static int getEventCount(Level level) {
        return ((LogEventCollector)LOG_EVENT_HANDLER.get()).getEventCount(level);
    }

    private static void ensureAttached() {
        LoggingUtils.initLogger();
        Set rootLoggersWithoutTeamscaleLogAppender = TeamscaleLogAppender.getAllLoggerContexts().stream().map(LoggerContext::getRootLogger).filter(rootLogger -> !rootLogger.getAppenders().containsKey(TEAMSCALE_LOG_APPENDER_NAME)).collect(Collectors.toSet());
        if (rootLoggersWithoutTeamscaleLogAppender.isEmpty()) {
            return;
        }
        TeamscaleLogAppender teamscaleLogAppender = TeamscaleLogAppender.createAppender(TEAMSCALE_LOG_APPENDER_NAME, null, null, false);
        teamscaleLogAppender.start();
        for (Logger rootLogger2 : rootLoggersWithoutTeamscaleLogAppender) {
            rootLogger2.addAppender((Appender)teamscaleLogAppender);
        }
    }

    private static Collection<LoggerContext> getAllLoggerContexts() {
        HashSet<LoggerContext> loggerContexts = new HashSet<LoggerContext>();
        loggerContexts.add((LoggerContext)LogManager.getContext((boolean)false));
        loggerContexts.add((LoggerContext)LogManager.getContext((boolean)true));
        LoggerContextFactory factory = LogManager.getFactory();
        ContextSelector selector = ((Log4jContextFactory)factory).getSelector();
        loggerContexts.addAll(selector.getLoggerContexts());
        return loggerContexts;
    }

    public static void init() {
        TeamscaleLogAppender.ensureAttached();
        TeamscaleLogAppender.clearOldLogEvents();
    }

    public static ExecutorService wrap(ExecutorService executorService) {
        return new TaskWrappingExecutorService(executorService, new TaskWrappingExecutorService.Wrapper(){

            public <T> @NonNull Callable<T> wrap(@NonNull Callable<T> callable) {
                return new LogEventPropagatingCallable<T>(callable);
            }

            public <T> @NonNull Callable<T> unwrap(@NonNull Callable<T> callable) {
                return ((LogEventPropagatingCallable)callable).delegate;
            }

            public @NonNull Runnable wrap(@NonNull Runnable runnable) {
                return new LogEventPropagatingRunnable(runnable);
            }

            public @NonNull Runnable unwrap(@NonNull Runnable runnable) {
                return ((LogEventPropagatingRunnable)runnable).delegate;
            }
        });
    }

    private static class LogEventPropagatingCallable<T>
    implements Callable<T> {
        private final Callable<T> delegate;
        private final LogEventCollector callingThreadLogEventHandler;

        public LogEventPropagatingCallable(Callable<T> delegate) {
            this.delegate = delegate;
            this.callingThreadLogEventHandler = (LogEventCollector)LOG_EVENT_HANDLER.get();
        }

        @Override
        public T call() throws Exception {
            LogEventCollector inheritedLogEventHandler = (LogEventCollector)LOG_EVENT_HANDLER.get();
            try {
                LOG_EVENT_HANDLER.set(this.callingThreadLogEventHandler);
                T t = this.delegate.call();
                return t;
            }
            finally {
                LOG_EVENT_HANDLER.set(inheritedLogEventHandler);
            }
        }
    }

    private static class LogEventPropagatingRunnable
    implements Runnable {
        private final Runnable delegate;
        private final LogEventCollector callingThreadLogEventHandler;

        public LogEventPropagatingRunnable(Runnable delegate) {
            this.delegate = delegate;
            this.callingThreadLogEventHandler = (LogEventCollector)LOG_EVENT_HANDLER.get();
        }

        @Override
        public void run() {
            LogEventCollector inheritedLogEventHandler = (LogEventCollector)LOG_EVENT_HANDLER.get();
            try {
                LOG_EVENT_HANDLER.set(this.callingThreadLogEventHandler);
                this.delegate.run();
            }
            finally {
                LOG_EVENT_HANDLER.set(inheritedLogEventHandler);
            }
        }
    }
}

