/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.shallowparser.preprocessor.ctc;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.function.Predicate;
import org.conqat.engine.sourcecode.shallowparser.preprocessor.ExclusionCounter;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class CtcSkipPragmaFilterBase
implements Predicate<ShallowEntity> {
    private static final String LITERAL_CTC_SKIP_END = "\"CTC ENDSKIP\"";
    private static final String LITERAL_CTC_SKIP_BEGIN = "\"CTC SKIP\"";
    private static final String PRAGMA_CTC_SKIP_BEGIN = "#pragma ctc skip";
    private static final String PRAGMA_CTC_SKIP_END = "#pragma ctc endskip";
    private final ExclusionCounter exclusionCounter = new ExclusionCounter();

    @Override
    public boolean test(ShallowEntity entity) {
        if (CtcSkipPragmaFilterBase.startsCtcSkip(entity)) {
            this.exclusionCounter.signalExclusionStart();
        }
        if (this.exclusionCounter.isExclusionActive()) {
            this.visitShallowEntityInCtcSkip(entity);
        }
        if (CtcSkipPragmaFilterBase.endsCtcSkip(entity)) {
            this.exclusionCounter.signalExclusionEnd();
        }
        return false;
    }

    private static boolean startsCtcSkip(ShallowEntity entity) {
        return !entity.ownStartTokens().isEmpty() && ((IToken)entity.ownStartTokens().get(0)).getText().trim().equalsIgnoreCase(PRAGMA_CTC_SKIP_BEGIN) || CtcSkipPragmaFilterBase.startsWithStringLiteral(entity, LITERAL_CTC_SKIP_BEGIN);
    }

    private static boolean startsWithStringLiteral(ShallowEntity entity, String literal) {
        if (entity.hasChildren()) {
            return false;
        }
        UnmodifiableList tokens = entity.includedTokens();
        if (tokens.isEmpty()) {
            return false;
        }
        IToken token = (IToken)tokens.get(0);
        return token.getType() == ETokenType.STRING_LITERAL && token.getText().equals(literal);
    }

    private static boolean endsCtcSkip(ShallowEntity entity) {
        return !entity.ownStartTokens().isEmpty() && ((IToken)entity.ownStartTokens().get(0)).getText().trim().equalsIgnoreCase(PRAGMA_CTC_SKIP_END) || CtcSkipPragmaFilterBase.startsWithStringLiteral(entity, LITERAL_CTC_SKIP_END);
    }

    protected abstract void visitShallowEntityInCtcSkip(ShallowEntity var1);
}

