/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.RobustCryptographicKeysCheckKt;

@Rule(key="S4426")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002JB\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0014"}, d2={"Lorg/sonarsource/kotlin/checks/RobustCryptographicKeysCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "handleECGenParameterSpec", "", "callExpr", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "handleKeyGeneratorAndKeyPairGenerator", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "minKeySize", "", "unsafeAlgorithms", "", "", "getInstanceMatcher", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "visitCallExpression", "sonar-kotlin-checks"})
public final class RobustCryptographicKeysCheck
extends AbstractCheck {
    @Override
    public void visitCallExpression(@NotNull KtCallExpression callExpr, @NotNull KotlinFileContext context) {
        block0: {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2;
            block2: {
                block1: {
                    Intrinsics.checkNotNullParameter(callExpr, "callExpr");
                    Intrinsics.checkNotNullParameter(context, "context");
                    ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall(callExpr, context.getBindingContext());
                    if (resolvedCall3 == null) break block0;
                    resolvedCall2 = resolvedCall3;
                    boolean bl = false;
                    if (!FunMatcherKt.matches(resolvedCall2, RobustCryptographicKeysCheckKt.access$getASYMMETRIC_INITIALIZE_MATCHER$p())) break block1;
                    this.handleKeyGeneratorAndKeyPairGenerator(callExpr, resolvedCall2, 2048, RobustCryptographicKeysCheckKt.access$getASYMMETRIC_ALGORITHMS$p(), RobustCryptographicKeysCheckKt.access$getASYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER$p(), context);
                    break block0;
                }
                if (!FunMatcherKt.matches(resolvedCall2, RobustCryptographicKeysCheckKt.access$getSYMMETRIC_INIT_MATCHER$p())) break block2;
                this.handleKeyGeneratorAndKeyPairGenerator(callExpr, resolvedCall2, 128, RobustCryptographicKeysCheckKt.access$getSYMMETRIC_ALGORITHMS$p(), RobustCryptographicKeysCheckKt.access$getSYMMETRIC_GENERATOR_GET_INSTANCE_MATCHER$p(), context);
                break block0;
            }
            if (!FunMatcherKt.matches(resolvedCall2, RobustCryptographicKeysCheckKt.access$getEC_GEN_PARAMETER_SPEC_MATCHER$p())) break block0;
            this.handleECGenParameterSpec(callExpr, context);
        }
    }

    private final void handleECGenParameterSpec(KtCallExpression callExpr, KotlinFileContext context) {
        block3: {
            String string2;
            KtExpression ktExpression = callExpr.getValueArguments().get(0).getArgumentExpression();
            if (ktExpression == null) break block3;
            KtExpression specArgExpr = ktExpression;
            boolean bl = false;
            Iterable iterable = RobustCryptographicKeysCheckKt.access$getINSECURE_EC_SPECS$p();
            String string3 = ApiExtensionsKt.predictRuntimeStringValue(specArgExpr, context.getBindingContext());
            if (string3 != null) {
                String string4 = string3.toLowerCase(Locale.ROOT);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
            } else {
                string2 = null;
            }
            if (CollectionsKt.contains(iterable, string2)) {
                AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)specArgExpr, RobustCryptographicKeysCheckKt.access$msg(224, "EC"), null, null, 12, null);
            }
        }
    }

    private final void handleKeyGeneratorAndKeyPairGenerator(KtCallExpression callExpr, ResolvedCall<?> resolvedCall2, int minKeySize, Collection<String> unsafeAlgorithms, FunMatcherImpl getInstanceMatcher, KotlinFileContext context) {
        block4: {
            ResolvedCall<? extends CallableDescriptor> getInstanceCall;
            BindingContext bindingContext2 = context.getBindingContext();
            KtExpression ktExpression = CallUtilKt.getFirstArgumentExpression(resolvedCall2);
            if (ktExpression == null) {
                return;
            }
            KtExpression keySizeExpression = ktExpression;
            Integer keySize = ApiExtensionsKt.predictRuntimeIntValue(keySizeExpression, bindingContext2);
            if (keySize == null || keySize >= minKeySize) break block4;
            KtExpression ktExpression2 = ApiExtensionsKt.predictReceiverExpression(callExpr, bindingContext2, resolvedCall2);
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = getInstanceCall = ktExpression2 != null ? CallUtilKt.getResolvedCall(ktExpression2, bindingContext2) : null;
            if (getInstanceMatcher.matches(getInstanceCall)) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall4 = getInstanceCall;
                KtExpression algoExpr = resolvedCall4 != null ? CallUtilKt.getFirstArgumentExpression(resolvedCall4) : null;
                Object object = algoExpr;
                if (object != null && (object = ApiExtensionsKt.predictRuntimeStringValue((KtExpression)object, bindingContext2)) != null) {
                    Object algo = object;
                    boolean bl = false;
                    String string2 = ((String)algo).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                    if (unsafeAlgorithms.contains(string2)) {
                        Pair[] pairArray = new Pair[]{TuplesKt.to(algoExpr, "Using " + (String)algo + " cipher algorithm")};
                        AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)keySizeExpression, RobustCryptographicKeysCheckKt.access$msg(minKeySize, (String)algo), this.locationListOf(context, pairArray), null, 8, null);
                    }
                }
            }
        }
    }
}

