/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.matcher;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

class TokenClassTokenMatcher
implements ITokenMatcher {
    private final Set<ETokenType.ETokenClass> tokenClasses = EnumSet.noneOf(ETokenType.ETokenClass.class);

    public TokenClassTokenMatcher(Collection<ETokenType.ETokenClass> tokenClasses) {
        this.tokenClasses.addAll(Objects.requireNonNull(tokenClasses, "tokenClasses"));
    }

    @Override
    public boolean matches(IToken token) {
        return this.tokenClasses.contains(token.getType().getTokenClass());
    }

    @Override
    public String humanReadable() {
        return this.tokenClasses.toString();
    }
}

