/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.findings.location;

import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.ILineAdjuster;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.region.LineBasedRegion;

public class SimpleValidLinesFilter
implements ILineAdjuster {
    private final int totalLineCount;

    public SimpleValidLinesFilter(int totalLineCount) {
        this.totalLineCount = totalLineCount;
    }

    public boolean isValidLine(int line) {
        return line > 0 && line <= this.totalLineCount;
    }

    @Override
    public LineBasedRegion adjustLine(int line, Set<Integer> invalidLines) {
        if (!this.isValidLine(line)) {
            invalidLines.add(line);
            return null;
        }
        return new LineBasedRegion(line, line);
    }

    @Override
    public int getOriginalLineCount() {
        return this.totalLineCount;
    }

    @Override
    public ElementLocation adjustLocation(ElementLocation location) {
        TextRegionLocation textRegionLocation;
        if (location instanceof TextRegionLocation && (textRegionLocation = (TextRegionLocation)location).getRawEndLine() > this.totalLineCount) {
            return null;
        }
        return location;
    }
}

