/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.function.Function;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSequencedMap;
import org.conqat.lib.commons.collections.UnmodifiableSequencedSet;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class UnmodifiableCollectionsModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public UnmodifiableCollectionsModule() {
        this.addDeserializer(UnmodifiableCollection.class, UnmodifiableCollectionDeserializer.of(CollectionUtils::asUnmodifiable));
        this.addDeserializer(UnmodifiableList.class, UnmodifiableCollectionDeserializer.of(collection -> UnmodifiableList.of(new ArrayList(collection))));
        this.addDeserializer(UnmodifiableSet.class, UnmodifiableCollectionDeserializer.of(collection -> UnmodifiableSet.of(new LinkedHashSet(collection))));
        this.addDeserializer(UnmodifiableSequencedSet.class, UnmodifiableCollectionDeserializer.of(collection -> UnmodifiableSequencedSet.of(new LinkedHashSet(collection))));
        this.addDeserializer(UnmodifiableMap.class, UnmodifiableMapDeserializer.create(UnmodifiableMap::of));
        this.addDeserializer(UnmodifiableSequencedMap.class, UnmodifiableMapDeserializer.create(UnmodifiableSequencedMap::of));
    }

    private static class UnmodifiableCollectionDeserializer<T, C extends UnmodifiableCollection<T>>
    extends JsonDeserializer<C>
    implements ContextualDeserializer {
        private final JavaType elementType;
        private final Function<Collection<T>, C> unmodifiableTransformer;

        private UnmodifiableCollectionDeserializer(JavaType elementType, Function<Collection<T>, C> unmodifiableTransformer) {
            this.elementType = elementType;
            this.unmodifiableTransformer = unmodifiableTransformer;
        }

        public static <T, C extends UnmodifiableCollection<T>> UnmodifiableCollectionDeserializer<T, C> of(Function<Collection<T>, C> unmodifiableTransformer) {
            return new UnmodifiableCollectionDeserializer<T, C>(null, unmodifiableTransformer);
        }

        public C deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Collection intermediate = (Collection)ctxt.readValue(p, (JavaType)ctxt.getTypeFactory().constructCollectionLikeType(ArrayList.class, this.elementType));
            return (C)((UnmodifiableCollection)this.unmodifiableTransformer.apply(intermediate));
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            JavaType propertyType = UnmodifiableCollectionDeserializer.getPropertyType(ctxt, property);
            return new UnmodifiableCollectionDeserializer<T, C>(propertyType.containedType(0), this.unmodifiableTransformer);
        }

        private static JavaType getPropertyType(DeserializationContext ctxt, BeanProperty property) {
            if (property == null) {
                return ctxt.getContextualType();
            }
            return property.getType();
        }
    }

    private static class UnmodifiableMapDeserializer<K, V, M extends UnmodifiableMap<K, V>>
    extends JsonDeserializer<M>
    implements ContextualDeserializer {
        private final JavaType keyType;
        private final JavaType valueType;
        private final Function<LinkedHashMap<K, V>, M> unmodifiableTransformer;

        private UnmodifiableMapDeserializer(JavaType keyType, JavaType valueType, Function<LinkedHashMap<K, V>, M> unmodifiableTransformer) {
            this.keyType = keyType;
            this.valueType = valueType;
            this.unmodifiableTransformer = unmodifiableTransformer;
        }

        public static <K, V, M extends UnmodifiableMap<K, V>> UnmodifiableMapDeserializer<K, V, M> create(Function<LinkedHashMap<K, V>, M> unmodifiableTransformer) {
            return new UnmodifiableMapDeserializer<K, V, M>(null, null, unmodifiableTransformer);
        }

        public M deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
            LinkedHashMap root = (LinkedHashMap)ctxt.readValue(parser, (JavaType)ctxt.getTypeFactory().constructMapType(LinkedHashMap.class, this.keyType, this.valueType));
            return (M)((UnmodifiableMap)this.unmodifiableTransformer.apply(root));
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            JavaType mapType = UnmodifiableCollectionDeserializer.getPropertyType(ctxt, property);
            return new UnmodifiableMapDeserializer<K, V, M>(mapType.containedType(0), mapType.containedType(1), this.unmodifiableTransformer);
        }
    }
}

