/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.teamscale.commons.lang.ToStringHelpers;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.ExternalStorageProjectMappingId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class ProjectInfo
implements Serializable,
Comparable<ProjectInfo> {
    private static final long serialVersionUID = 1L;
    private static final String INTERNAL_ID_PROPERTY = "internalId";
    private static final String EXTERNAL_STORAGE_PROJECT_MAPPING_ID_PROPERTY = "externalStorageProjectMappingId";
    private static final String PRESELECTED_UI_BRANCH = "preselectedUIBranch";
    private static final String NAME_PROPERTY = "name";
    private static final String PUBLIC_IDS_PROPERTY = "publicIds";
    private static final String PARENT_PROJECT_ID_PROPERTY = "parentProjectId";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String CREATION_TIMESTAMP_PROPERTY = "creationTimestamp";
    public static final String MAINTENANCE_PROJECT_INTERNAL_NAME = "##maintenance##";
    @JsonProperty(value="internalId")
    private final @Nullable InternalProjectId internalId;
    @JsonProperty(value="preselectedUIBranch")
    private @Nullable String preselectedUIBranch;
    @JsonProperty(value="externalStorageProjectMappingId")
    private final @Nullable ExternalStorageProjectMappingId externalStorageProjectMappingId;
    @JsonProperty(value="publicIds")
    private List<PublicProjectId> publicIds;
    @JsonProperty(value="parentProjectId")
    private @Nullable InternalProjectId parentProjectId;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private @Nullable String description;
    @JsonProperty(value="creationTimestamp")
    private long creationTimestamp;
    @JsonProperty(value="deleting")
    private boolean deleting = false;
    @JsonProperty(value="reanalyzing")
    private boolean reanalyzing = false;
    @JsonProperty(value="copyingData")
    private boolean copyingData = false;
    @JsonProperty(value="configurationCompleted")
    private boolean configurationCompleted = true;

    public ProjectInfo(String name, List<PublicProjectId> publicIds, InternalProjectId parentProjectId, String description, long creationTimestamp) {
        this(InternalProjectId.create(), ExternalStorageProjectMappingId.create(), name, publicIds, parentProjectId, description, creationTimestamp, null);
    }

    @JsonCreator
    public ProjectInfo(@JsonProperty(value="internalId") @Nullable InternalProjectId internalId, @JsonProperty(value="externalStorageProjectMappingId") @Nullable ExternalStorageProjectMappingId externalStorageProjectMappingId, @JsonProperty(value="name") String name, @JsonProperty(value="publicIds") List<PublicProjectId> publicIds, @JsonProperty(value="parentProjectId") @Nullable InternalProjectId parentProjectId, @JsonProperty(value="description") @Nullable String description, @JsonProperty(value="creationTimestamp") long creationTimestamp, @JsonProperty(value="preselectedUIBranch") @Nullable String preselectedUIBranch) {
        this.internalId = Objects.requireNonNullElseGet(internalId, InternalProjectId::create);
        this.externalStorageProjectMappingId = Objects.requireNonNullElseGet(externalStorageProjectMappingId, ExternalStorageProjectMappingId::create);
        this.setPublicIds(publicIds);
        this.name = name;
        this.parentProjectId = parentProjectId;
        this.description = description;
        this.creationTimestamp = creationTimestamp;
        this.preselectedUIBranch = preselectedUIBranch;
    }

    public @NonNull InternalProjectId getInternalId() {
        return Objects.requireNonNull(this.internalId, "Internal ID was expected to be set in the constructor!");
    }

    public @NonNull ExternalStorageProjectMappingId getExternalStorageProjectMappingId() {
        return Objects.requireNonNull(this.externalStorageProjectMappingId, "externalStorageProjectMappingId was expected to be set in the constructor!");
    }

    public PublicProjectId getPrimaryPublicId() {
        return this.publicIds.getFirst();
    }

    public UnmodifiableList<PublicProjectId> getPublicIds() {
        return CollectionUtils.asUnmodifiable(this.publicIds);
    }

    public void setPublicIds(List<PublicProjectId> publicIds) {
        Preconditions.checkState((!CollectionUtils.isNullOrEmpty(publicIds) || this.isDeleting() ? 1 : 0) != 0, (Object)"At least one public ID needs to be provided.");
        this.publicIds = publicIds;
    }

    public Optional<InternalProjectId> getParentProjectId() {
        return Optional.ofNullable(this.parentProjectId);
    }

    public void setParentProjectId(@Nullable InternalProjectId parentProjectId) {
        this.parentProjectId = parentProjectId;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable String getPreselectedUIBranch() {
        return this.preselectedUIBranch;
    }

    public void setName(String name) {
        this.name = name;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(long creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public boolean isDeleting() {
        return this.deleting;
    }

    public boolean isReanalyzing() {
        return this.reanalyzing;
    }

    public boolean isDeletingOrReanalyzing() {
        return this.isDeleting() || this.isReanalyzing();
    }

    public void setDeleting(boolean deleting) {
        this.deleting = deleting;
    }

    public void setReanalyzing(boolean reanalyzing) {
        this.reanalyzing = reanalyzing;
    }

    public void setConfigurationCompleted(boolean configurationCompleted) {
        this.configurationCompleted = configurationCompleted;
    }

    public boolean isConfigurationCompleted() {
        return this.configurationCompleted;
    }

    public void setCopyingData(boolean copyingData) {
        this.copyingData = copyingData;
    }

    public void setPreselectedUIBranch(@Nullable String preselectedUIBranch) {
        this.preselectedUIBranch = preselectedUIBranch;
    }

    public boolean isCopyingData() {
        return this.copyingData;
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper(this).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ProjectInfo that = (ProjectInfo)other;
        return Objects.equals(this.internalId, that.internalId) && Objects.equals(this.publicIds, that.publicIds) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.internalId, this.publicIds, this.name);
    }

    @Override
    public int compareTo(ProjectInfo other) {
        if (other == null) {
            return -1;
        }
        if (this.getPrimaryPublicId().toString().equals(MAINTENANCE_PROJECT_INTERNAL_NAME) && !other.getPrimaryPublicId().toString().equals(MAINTENANCE_PROJECT_INTERNAL_NAME)) {
            return -1;
        }
        if (other.getPrimaryPublicId().toString().equals(MAINTENANCE_PROJECT_INTERNAL_NAME) && !this.getPrimaryPublicId().toString().equals(MAINTENANCE_PROJECT_INTERNAL_NAME)) {
            return 1;
        }
        return Comparator.comparing(ProjectInfo::getName, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(ProjectInfo::getPrimaryPublicId, Comparator.nullsLast(Comparator.naturalOrder())).compare(this, other);
    }
}

