import{_ as e,h as a,ak as i,g as n}from"./chunks/framework.B7a_7emw.js";const k=JSON.parse('{"title":"Accessing Teamscale via Reverse Proxy","description":"","frontmatter":{"title":"Accessing Teamscale via Reverse Proxy"},"headers":[],"relativePath":"howto/configuring-reverse-proxy/index.md","filePath":"howto/configuring-reverse-proxy/index.md"}'),t={name:"howto/configuring-reverse-proxy/index.md"};function r(o,s,l,p,h,c){return n(),a("div",null,[...s[0]||(s[0]=[i(`<h1 id="how-to-access-teamscale-via-a-reverse-proxy" tabindex="-1">How to access Teamscale via a Reverse Proxy <a class="header-anchor" href="#how-to-access-teamscale-via-a-reverse-proxy" aria-label="Permalink to &quot;How to access Teamscale via a Reverse Proxy&quot;">​</a></h1><p>Instead of making Teamscale directly accessible from the web you can consider operating Teamscale behind a reverse proxy, such as NGINX or Apache. Reverse proxies allow you to fulfill certain requirements, such as different authentication mechanisms or HTTPS support. Moreover, you can seamlessly redirect traffic to different Teamscale instances, e.g., if you want to upgrade to a new version of Teamscale.</p><nav class="table-of-contents"><ul><li><a href="#general-considerations">General considerations</a><ul><li><a href="#public-teamscale-url">Public Teamscale URL</a></li><li><a href="#restrict-direct-access-to-teamscale">Restrict direct access to Teamscale</a></li></ul></li><li><a href="#nginx">NGINX</a><ul><li><a href="#basic-configuration">Basic configuration</a></li><li><a href="#advanced-configuration">Advanced configuration</a></li></ul></li><li><a href="#apache-httpd">Apache httpd</a></li></ul></nav><h2 id="general-considerations" tabindex="-1">General considerations <a class="header-anchor" href="#general-considerations" aria-label="Permalink to &quot;General considerations&quot;">​</a></h2><p>Before looking into the configuration that is specific to a reverse proxy solution, some general considerations should be taken into account.</p><h3 id="public-teamscale-url" tabindex="-1">Public Teamscale URL <a class="header-anchor" href="#public-teamscale-url" aria-label="Permalink to &quot;Public Teamscale URL&quot;">​</a></h3><p>The most important one is the URL that Teamscale will be accessible. In practice there are two options:</p><ul><li>Teamscale is accessible via the domain root, e.g., <code>http://teamscale.mydomain.tld</code></li><li>Teamscale is accessible via a subpath, e.g., <code>http://mydomain.tld/teamscale</code></li></ul><p>Both scenarios can be achieved with or without a reverse proxy. Especially if you want to provide another service (e.g. <code>http://mydomain.tld/other-service</code>) you may want to use a reverse proxy.</p><div class="warning custom-block"><p class="custom-block-title">Using subpaths</p><p>It is highly recommended to configure the subpath of the reverse proxy and Teamscale <strong>exactly</strong> the same way to avoid redirect and path encoding issues.</p><p>In practice this means:</p><ul><li>If Teamscale is accessible via the domain root, do neither specify a subpath in the reverse proxy nor in Teamscale</li><li>If Teamscale should be accessible via a subpath, configure the reverse proxy and Teamscale using <strong>exactly</strong> the same subpath. Configuring a different or no subpath in Teamscale is error-prone and requires advanced knowledge of the used reverse proxy.</li></ul></div><p>The subpath of Teamscale can be configured in <code>teamscale.properties</code> using the following property (if the property is not set, no subpath is configured):</p><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">server.urlprefix</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=teamscale</span></span></code></pre></div><h3 id="restrict-direct-access-to-teamscale" tabindex="-1">Restrict direct access to Teamscale <a class="header-anchor" href="#restrict-direct-access-to-teamscale" aria-label="Permalink to &quot;Restrict direct access to Teamscale&quot;">​</a></h3><p>In the default configuration Teamscale is listening to port 8080 and is available from any browser that can access the server Teamscale is running on. You can restrict direct access to Teamscale in several ways, so access via the reverse proxy cannot be circumvented:</p><ul><li>If Teamscale and the reverse proxy are running in Docker containers, please use common Docker networking techniques to prevent access, e.g. not exposing the Teamscale port to the host but only to a Docker-network.</li><li>If Teamscale and the reverse proxy are running on the same server without Docker, one can ensure that the instance is reachable only from the local machine by specifying the bind hostname in <code>teamscale.properties</code>:<div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">server.bind-hostname</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=localhost</span></span></code></pre></div></li><li>If Teamscale and the reverse proxy are running on different servers, firewall rules may be used.</li></ul><h2 id="nginx" tabindex="-1">NGINX <a class="header-anchor" href="#nginx" aria-label="Permalink to &quot;NGINX&quot;">​</a></h2><p><a href="http://nginx.org/" target="_blank" rel="noreferrer">NGINX</a> is a HTTP and reverse proxy server that runs under Windows and Linux. It supports different authentication mechanisms or HTTPS termination and is a lightweight alternative to Apache HTTP Server or Microsoft IIS. You can find a complete nginx configuration in our example <a href="https://github.com/cqse/teamscale-docker-deployment" target="_blank" rel="noreferrer">Docker setup</a>, which follows security best practices and can handle multiple Teamscale instances.</p><h3 id="basic-configuration" tabindex="-1">Basic configuration <a class="header-anchor" href="#basic-configuration" aria-label="Permalink to &quot;Basic configuration&quot;">​</a></h3><div class="warning custom-block"><p class="custom-block-title">Incomplete Configuration Examples</p><p>The following configuration snippets only represent incomplete configuration examples to demonstrate certain use cases. Before deploying, make sure the nginx configuration follows the security guidelines of your organisation. The <a href="https://ssl-config.mozilla.org/#server=nginx&amp;config=modern" target="_blank" rel="noreferrer">Mozilla SSL Configuration Generator</a> might serve as a starting point for a secure configuration.</p></div><h4 id="serve-from-domain-root" tabindex="-1">Serve from domain root <a class="header-anchor" href="#serve-from-domain-root" aria-label="Permalink to &quot;Serve from domain root&quot;">​</a></h4><p>The following configuration may be used as a starting point if Teamscale should be served at the domain root. It should be adopted to the specific use case according to the <a href="http://nginx.org/en/docs/http/ngx_http_proxy_module.html" target="_blank" rel="noreferrer">documentation</a>.</p><div class="language-nginx vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">nginx</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">events</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> {</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">  worker_connections </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">1024</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">http</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> {</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">  # Do not display the server version</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">  server_tokens </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">off</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">  server</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> {</span></span>
<span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">    # This is the default server listening on port 80</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">    listen </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">80</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> default_server</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">;</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">    location</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> / </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">{</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      proxy_set_header </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">Host $host;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      proxy_set_header </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">X-Real-IP $remote_addr;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      proxy_set_header </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">X-Forwarded-For $proxy_add_x_forwarded_for;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      proxy_set_header </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">X-Forwarded-Proto $scheme;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      proxy_set_header </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">X-Forwarded-Host $server_name;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      proxy_set_header </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">X-Forwarded-Prefix </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      proxy_set_header </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">X-Forwarded-Port </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">80</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      </span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      set </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">$teamscaleHost localhost;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      proxy_pass </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">http://$teamscaleHost:8080;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  }</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div><p>The <code>proxy_pass</code> argument to the Teamscale server is extracted as variable <code>$teamscaleHost</code>. This prevents issues with DNS caching that may yield to <a href="https://ypereirareis.github.io/blog/2020/02/18/how-to-reduce-nginx-502-bad-gateway-errors-risks-with-dynamic-domain-name-resolution/" target="_blank" rel="noreferrer">502 Bad Gateway</a> errors. You can specify the hostname directly, e.g., <code>proxy_pass http://localhost:8080</code> if Teamscale is running on the same network or can be accessed via <code>localhost</code>.</p><div class="warning custom-block"><p class="custom-block-title">WARNING</p><p>Ensure that the argument of <code>proxy_pass</code> is specified as <code>protocol://hostname:port</code> and does not include a subpath, even not a trailing slash, e.g. <code>protocol://hostname:port/</code>. Specifying a subpath (URI) will yield to <a href="http://nginx.org/en/docs/http/ngx_http_proxy_module.html#proxy_pass" target="_blank" rel="noreferrer">normalization</a> of the request URL before it is passed to Teamscale.</p></div><h4 id="serve-from-subpath" tabindex="-1">Serve from subpath <a class="header-anchor" href="#serve-from-subpath" aria-label="Permalink to &quot;Serve from subpath&quot;">​</a></h4><p>If Teamscale should be served from a subpath, <strong>only</strong> the <code>location</code> in the nginx configuration needs to be changed. The following example shows the configuration for the subpath <code>/teamscale</code>:</p><div class="language-nginx vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">nginx</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line highlighted"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">    location</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> /teamscale </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">{</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      proxy_set_header </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">Host $host;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      proxy_set_header </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">X-Real-IP $remote_addr;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      proxy_set_header </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">X-Forwarded-For $proxy_add_x_forwarded_for;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      proxy_set_header </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">X-Forwarded-Proto $scheme;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      proxy_set_header </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">X-Forwarded-Host $server_name;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      proxy_set_header </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">X-Forwarded-Prefix </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;/teamscale&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      proxy_set_header </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">X-Forwarded-Port </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">80</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">      </span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      set </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">$teamscaleHost localhost;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">      proxy_pass </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">http://$teamscaleHost:8080;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">    }</span></span></code></pre></div><div class="warning custom-block"><p class="custom-block-title">WARNING</p><p><strong>Do not</strong> add the subpath to <code>proxy_pass</code>. Instead the subpath needs to be defined in <code>teamscale.properties</code> and set to, e.g., <code>server.urlprefix=teamscale</code>.</p></div><p>The &quot;X-Forwarded-*&quot; headers need to reflect how Teamscale is exposed to the end user.</p><h3 id="advanced-configuration" tabindex="-1">Advanced configuration <a class="header-anchor" href="#advanced-configuration" aria-label="Permalink to &quot;Advanced configuration&quot;">​</a></h3><h4 id="redirecting-the-domain-root" tabindex="-1">Redirecting the domain root <a class="header-anchor" href="#redirecting-the-domain-root" aria-label="Permalink to &quot;Redirecting the domain root&quot;">​</a></h4><p>If you have multiple TS instances mounted on subdirectories (e.g. /teamscale, /staging etc.), you can redirect the root URL (the server name without any path) to one of these:</p><div class="language-nginx vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">nginx</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">location</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> =</span><span style="--shiki-light:#032F62;--shiki-dark:#DBEDFF;"> / </span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">{</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">    return</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> 301</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> https://$host/teamscale;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">}</span></span></code></pre></div><h2 id="apache-httpd" tabindex="-1">Apache httpd <a class="header-anchor" href="#apache-httpd" aria-label="Permalink to &quot;Apache httpd&quot;">​</a></h2><p><a href="https://httpd.apache.org/" target="_blank" rel="noreferrer">Apache</a> is a open-source HTTP server that supports different authentication mechanisms and HTTPS termination. With the <a href="https://httpd.apache.org/docs/trunk/mod/mod_proxy.html" target="_blank" rel="noreferrer">mod_proxy Module</a> other applications can be reverse-proxied.</p><div class="tip custom-block"><p class="custom-block-title">TIP</p><p>Apache HTTP Server is mostly used to manage larger domains and sites. Especially for the simple scenario of serving Teamscale on the domain root, the use of NGINX is recommended.</p></div><p>The following configuration may serve as a starting point if Teamscale should be served at a subpath.</p><div class="language-txt vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">txt</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>ProxyPass /teamscale</span></span>
<span class="line"><span>  http://localhost:8080/teamscale nocanon</span></span>
<span class="line"><span>ProxyPassReverse /teamscale</span></span>
<span class="line"><span>  http://localhost:8080/teamscale</span></span>
<span class="line"><span>ProxyRequests Off</span></span>
<span class="line"><span></span></span>
<span class="line"><span># This is important, as otherwise some URLs are blocked by Apache</span></span>
<span class="line"><span>AllowEncodedSlashes NoDecode</span></span></code></pre></div><p>Depending on your configuration and goals, slightly different and additional directives are required. Please refer to the <a href="https://httpd.apache.org/docs/trunk/mod/mod_proxy.html" target="_blank" rel="noreferrer">Apache manual</a> for more information.</p>`,39)])])}const g=e(t,[["render",r]]);export{k as __pageData,g as default};
