Abap methods should declare only one type of exception. 
In most cases, throwing multiple exceptions has no use.
The caller of such methods can usually not distinguish between the different error situations.
Therefore, the different situations will be handled in the same way, so declaring different exceptions is not useful.

If different error situations should be modelled, a better solution would be to use one exception type and 
add subclasses of that exception type to allow reacting to different situations.
As an alternative, you could store the reason as an error code in the exception type.

# How Can I Resolve This?

Migrate the exception types to one type with subclasses or store the reason in the exception.

## Example (Before)

```ABAP
METHODS my_method
  RAISING
    cx_access_error
    cx_illegal_state_error.
```

## Example (After)

```ABAP
CLASS cx_access_error_variable DEFINITION INHERITING FROM cx_my_method_error.
CLASS cx_illegal_state_error_variable DEFINITION INHERITING FROM cx_my_method_error.

METHODS generate RAISING cx_my_method.

TRY.
    my_class->my_method( ).
  CATCH cx_access_error_variable.
    log_failure( ).
  CATCH cx_illegal_state_error_variable INTO DATA(cx_illegal_state_error).
    show_error_to_user( cx_illegal_state_error ).
ENDTRY.
```

# Where Can I Learn More?

## References

- [Clean ABAP guideline, Throw one type of exception](https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#throw-one-type-of-exception)