Using `contains()` on lists can lead to inefficient performance, especially with large data sets.
Consider using a `HashSet` or another appropriate data structure that allows for faster look-ups.

# What Does This Check Look For?

This check identifies occurrences where the `contains()` method is called on objects of type `List`.

# Why is This a Problem?

The `contains()` method for a `List` typically requires iterating over all elements of the list to check for the presence of a specific value. This operation is linear in time complexity (O(n)), meaning the time taken grows linearly with the number of elements in the list. For large lists, this can significantly impact performance, making operations slow.
In contrast, structures like `HashSet` have a constant time complexity (O(1)) for look-up operations, irrespective of the size of the data structure. This can lead to substantial performance improvements, especially in scenarios where frequent look-up operations are required.

# How Can I Resolve This?

If the order of the elements and duplicates are not relevant, consider replacing the list with a `HashSet`. The `contains` operation on a `HashSet` has a time complexity of O(1).
If the order of the elements or duplicates are relevant, consider replacing the list with `MultiSet` from [Google Guava](https://github.com/google/guava) or a similar data structure.

This change ensures that the look-up operations are efficient, greatly enhancing the performance of your application in scenarios with large data sets.

# Examples

## Non-Compliant

```java
List<String> myList = new ArrayList<>();
// Some operations that insert many elements into the collection
if (myList.contains("someValue")) {
    // Do something
}
```

## Compliant

```java
Set<String> mySet = new HashSet<>();
// Some operations that insert many elements into the collection
if (mySet.contains("someValue")) {
    // Do something
}
```