Ignoring the result of methods on `BigDecimal` or `BigInteger` instances often indicates misunderstanding their immutable nature.
Use the result of these method calls or reassess the necessity of the call.

# What Does This Check Look For?

This check identifies occurrences where methods on `BigDecimal` or `BigInteger` objects are called but their results are not used.

# Why is This a Problem?

`BigDecimal` and `BigInteger` are immutable classes; methods do not change the instance but return a new instance with the result. Ignoring these results means the method call has no effect, potentially leading to incorrect program behavior or inefficiencies.

# How Can I Resolve This?

Ensure that the result of each method call is either assigned to a variable or returned. This makes sure the intended operation is effectively utilized, thereby avoiding any confusion about the immutability of `BigDecimal` and `BigInteger`.

# Examples

## Non-Compliant

```java
BigDecimal price = new BigDecimal("19.99");
price.add(new BigDecimal("3.00")); // non-compliant: result of add is ignored
```

## Compliant

```java
BigDecimal price = new BigDecimal("19.99");
price = price.add(new BigDecimal("3.00")); // compliant: result of add is used
```
