The `ThreadLocal` API can lead to surprising and non-deterministic behavior in concurrent applications.
Consider using alternative concurrent data structures or properly managing thread-local data.

# What Does This Check Look For?

This check identifies instances where the `ThreadLocal` API is used in the code.

# Why is This a Problem?

Using the `ThreadLocal` API allows storing data that will be accessible only by a specific thread.
This can be used for optimized algorithms and data structures used within controlled execution contexts with a fixed number of threads.
If the performance of these algorithms and data structures is not the top priority of the implementation, using `ThreadLocal` (or its subclass `InheritableThreadLocal`) often indicates a design flaw, and developers have to cope with the following issues:

- Using `ThreadLocal`s is error-prone when used with dynamic threading techniques, e.g., `Executor`s or thread pools.
  If there is no necessary cleanup of thread-local data, the provision of non-anticipated threads causes surprising and non-deterministic consequences, especially in highly concurrent applications.
- When a `ThreadLocal` is static, make sure it holds no data specific to a single thread.
  Problems arise here if the instance is accessed by multiple threads.

# How Can I Resolve This?

Replace `ThreadLocal`s with concurrent data structures inside your data structures and algorithms.
Also, measure or estimate if the performance benefit desired by using `ThreadLocal`s is necessary and actually reached.

# Where Can I Learn More?

- [Code Review Checklist (Java Concurrency): Item TL.1](https://github.com/code-review-checklists/java-concurrency#tl-static-final)
- [Code Review Checklist (Java Concurrency): Item TL.2](https://github.com/code-review-checklists/java-concurrency#threadlocal-design)
- [Code Review Checklist (Java Concurrency): Item TL.3](https://github.com/code-review-checklists/java-concurrency#threadlocal-performance)
- [Code Review Checklist (Java Concurrency): Item TL.4](https://github.com/code-review-checklists/java-concurrency#tl-instance-chm)
