``` python
# Python 2 only:
exec 'x = 10'

# Python 2 and 3:
exec('x = 10')
```
  
``` python
# Python 2 only:
g = globals()
exec 'x = 10' in g

# Python 2 and 3:
g = globals()
exec('x = 10', g)
```
  
``` python
# Python 2 only:
l = locals()
exec 'x = 10' in g, l

# Python 2 and 3:
exec('x = 10', g, l)
```
  
But note that Py3's `exec()` is less powerful (and less dangerous) than Py2's `exec` statement.

See also [Cheat Sheet: Writing Python 2-3 compatible code](http://python-future.org/compatible_idioms.html)

[Copyright (c) 2013-2016 Python Charmers Pty Ltd, Australia](https://github.com/PythonCharmers/python-future/blob/master/LICENSE.txt)