Directives `using` or `using namespace` used in header files can unexpectedly pollute the namespace of other files that include said header.
Reference anything from another namespace with its fully qualified name instead.

# What Does This Check Look For?

This check detects `using` and `using namespace` directives when used at global scope in a header file.

# Why is This a Problem?

This is considered a design flaw, as it pollutes the namespace of all files including the offending header file; they can no longer use the name for anything else.
It can also make names ambiguous and cause the result of header includes to become order-dependent.

# How Can I Resolve This?

Remove any `using` or `using namespace` directives in the header file and reference anything from another namespace with its fully qualified name instead.

# Examples
## Non-Compliant

```cpp
// library.h
#include <iostream>

using namespace std;

void hello(string& name) {
    cout << "Hello " << name << endl;
}
```

```cpp
// main.cpp
#include "library.h"

bool copy( /* args */ );

int main()
{
    copy( /*...*/ );  // Possibly ambiguous: local ::copy or std::copy?
}
```

## Compliant

```cpp
// library.h
#include <iostream>

void hello(std::string& name) {
    std::cout << "Hello " << name << std::endl;
}
```

```cpp
// main.cpp
#include "library.h"

bool copy( /* args */ );

int main()
{
    copy( /*...*/ );  // Unambiguous: local ::copy
}
```

# Where Can I Learn More?

* [Guideline: C++ Core Guidelines: SF.7 - Don’t write using namespace at global scope in a header file](https://isocpp.github.io/CppCoreGuidelines/CppCoreGuidelines#sf7-dont-write-using-namespace-at-global-scope-in-a-header-file)
* [Microsoft C++ Language Reference: Header files](https://docs.microsoft.com/en-us/cpp/cpp/header-files-cpp)