Declaring variables or parameters that are never used can make the code harder to read and maintain.
Instead, define variables and parameters only if they are actually needed.

# What Does This Check Look For?
This check reports a finding when a variable or function parameter is declared but never used anywhere in the program's scope.
# Why is This a Problem?
Unused variables and parameters can confuse developers, making them question whether the variable was mistakenly left unused or if it was part of an incomplete implementation.
This can lead to unnecessary debugging efforts and cluttered code. In some cases, it might cause unintended behavior in future modifications if developers assume the variable should be used.
# How Can I Resolve This?
Unused variables and parameters should be removed to improve code clarity and maintainability.
Before removing them, ensure that they were not meant to be used and were not omitted due to an implementation mistake.
# Examples
## Non-Compliant

```matlab
function result = computeValue(x)
    unusedVar = 42; % Non-compliant: variable is declared but never used
    result = x * 2;
end
```
## Compliant

```matlab
function result = computeValue(x)
    result = x * 2;
end
```

# Where Can I Learn More?
- [Clean Code: A Handbook of Agile Software Craftsmanship by Robert C. Martin](https://www.goodreads.com/book/show/3735293-clean-code)
- [Code Complete: A Practical Handbook of Software Construction, Second Edition by Steve McConnell](https://www.goodreads.com/book/show/4845.Code_Complete)
