<h2>Why is this an issue?</h2>
<p>Annotating unit tests with more than one test-related annotation is not only useless but could also result in unexpected behavior like failing
tests or unwanted side-effects.</p>
<p>This rule reports an issue when a test method is annotated with more than one of the following competing annotation:</p>
<ul>
  <li> @Test </li>
  <li> @RepeatedTest </li>
  <li> @ParameterizedTest </li>
  <li> @TestFactory </li>
  <li> @TestTemplate </li>
</ul>
<h3>Noncompliant code example</h3>

```java
@Test
@RepeatedTest(2) // Noncompliant, this test will be repeated 3 times
void test() { }

@ParameterizedTest
@Test
@MethodSource("methodSource")
void test2(int argument) { } // Noncompliant, this test will fail with ParameterResolutionException
```
<h3>Compliant solution</h3>

```java
@RepeatedTest(2)
void test() { }

@ParameterizedTest
@MethodSource("methodSource")
void test2(int argument) { }
```