# Description
Checks for ambiguity between deleting or modifying from internal and database table.
Add `TABLE` keyword or `@` for escaping SQL variables.

Only works if the target version is 740sp05 or above.

# Examples
**Bad example**
```abap
DELETE foo FROM bar.
MODIFY foo FROM bar.
```

**Good example**
```abap
DELETE foo FROM @bar.
MODIFY TABLE foo FROM bar.
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/ambiguous_statement) <br>
